/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import com.healthmarketscience.jackcess.DataType;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.ucanaccess.converters.RegionalSettings;
import net.ucanaccess.converters.TypesMap;
import net.ucanaccess.ext.FunctionType;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public class Functions {
    private static Double rnd;
    private static Double lastRnd;
    public static final ArrayList<SimpleDateFormat> LDF;
    public static final ArrayList<Boolean> LDFY;
    public static final RegionalSettings reg;
    private static final double APPROX = 1.0E-8;
    private static boolean pointDateSeparator;

    static {
        LDF = new ArrayList();
        LDFY = new ArrayList();
        reg = new RegionalSettings();
        pointDateSeparator = Functions.getPointDateSeparator();
        Functions.addDateP("yyyy-MM-dd h:m:s a");
        Functions.addDateP("yyyy-MM-dd H:m:s");
        Functions.addDateP("yyyy-MM-dd");
        Functions.addDateP("yyyy/MM/dd h:m:s a");
        Functions.addDateP("yyyy/MM/dd H:m:s");
        Functions.addDateP("yyyy/MM/dd");
        Functions.addDateP(reg.getGeneralPattern(), true);
        Functions.addDateP(reg.getLongDatePattern(), true);
        Functions.addDateP(reg.getMediumDatePattern(), true);
        Functions.addDateP(reg.getShortDatePattern(), true);
        if (!Locale.getDefault().equals(Locale.US)) {
            RegionalSettings s = new RegionalSettings(Locale.US);
            Functions.addDateP(s.getGeneralPattern(), false);
            Functions.addDateP(s.getLongDatePattern(), true);
            Functions.addDateP(s.getMediumDatePattern(), true);
            Functions.addDateP(s.getShortDatePattern(), true);
        }
        Functions.addDateP("MMM dd,yyyy");
        Functions.addDateP("MM dd,yyyy");
        Functions.addDateP("MMM dd hh:mm:ss", false, true);
        Functions.addDateP("MM dd hh:mm:ss", false, true);
        Functions.addDateP("MMM yy hh:mm:ss");
        Functions.addDateP("MM yy hh:mm:ss");
        Functions.addDateP("dd/MM/yyyy h:m:s a", true);
        Functions.addDateP("dd/MM/yyyy H:m:s", true);
        Functions.addDateP("dd/MM/yyyy", true);
    }

    private static boolean getPointDateSeparator() {
        String[] dfsp;
        String[] stringArray = dfsp = new String[]{reg.getGeneralPattern(), reg.getLongDatePattern(), reg.getMediumDatePattern(), reg.getShortDatePattern()};
        int n = dfsp.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (pattern.indexOf(".") > 0 && pattern.indexOf("h.") < 0 && pattern.indexOf("H.") < 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void addDateP(String sdfs) {
        Functions.addDateP(sdfs, false, false);
    }

    private static void addDateP(String sdfs, boolean euristic) {
        Functions.addDateP(sdfs, euristic, false);
    }

    private static void addTogglePattern(String pattern) {
        if (pattern.indexOf("/") > 0) {
            Functions.addDateP(pattern.replaceAll("/", "-"));
            if (pointDateSeparator) {
                Functions.addDateP(pattern.replaceAll("/", "."));
            }
        } else if (pattern.indexOf("-") > 0) {
            Functions.addDateP(pattern.replaceAll(Pattern.quote("-"), "/"));
            if (pointDateSeparator) {
                Functions.addDateP(pattern.replaceAll(Pattern.quote("-"), "."));
            }
        } else if (pattern.indexOf(".") > 0 && pattern.indexOf("h.") < 0 && pattern.indexOf("H.") < 0) {
            Functions.addDateP(pattern.replaceAll(Pattern.quote("."), "/"));
        }
    }

    private static void addDateP(String sdfs, boolean euristic, boolean yearOverride) {
        if (euristic && sdfs.indexOf("a") < 0 && sdfs.indexOf("H") > 0) {
            String chg = String.valueOf(sdfs.replaceAll("H", "h")) + " a";
            Functions.addDateP(chg);
            Functions.addTogglePattern(chg);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(sdfs);
        sdf.setLenient(false);
        if ("true".equalsIgnoreCase(reg.getRS())) {
            DateFormatSymbols df = new DateFormatSymbols();
            df.setAmPmStrings(new String[]{"AM", "PM"});
            sdf.setDateFormatSymbols(df);
        }
        LDF.add(sdf);
        LDFY.add(yearOverride);
        if (euristic) {
            Functions.addTogglePattern(sdfs);
            if (sdfs.endsWith(" a") && sdfs.indexOf("h") > 0) {
                String chg = sdfs.substring(0, sdfs.length() - 2).trim().replaceAll("h", "H");
                Functions.addDateP(chg);
                Functions.addTogglePattern(chg);
            }
        }
    }

    @FunctionType(functionName="ASC", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer asc(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s.charAt(0);
    }

    @FunctionType(functionName="EQUALS", argumentTypes={TypesMap.AccessType.COMPLEX, TypesMap.AccessType.COMPLEX}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean equals(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        if (obj1.getClass().isArray()) {
            return Arrays.equals((Object[])obj1, (Object[])obj2);
        }
        return obj1.equals(obj2);
    }

    @FunctionType(functionName="EQUALSIGNOREORDER", argumentTypes={TypesMap.AccessType.COMPLEX, TypesMap.AccessType.COMPLEX}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean equalsIgnoreOrder(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        if (obj1.getClass().isArray()) {
            List<Object> lo2;
            List<Object> lo1 = Arrays.asList((Object[])obj1);
            if (lo1.containsAll(lo2 = Arrays.asList((Object[])obj2)) && lo2.containsAll(lo1)) {
                return true;
            }
            return false;
        }
        return obj1.equals(obj2);
    }

    @FunctionType(functionName="CONTAINS", argumentTypes={TypesMap.AccessType.COMPLEX, TypesMap.AccessType.COMPLEX}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean contains(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (!obj1.getClass().isArray()) {
            return false;
        }
        List<Object> lo = Arrays.asList((Object[])obj1);
        List<Object> arg = obj2.getClass().isArray() ? Arrays.asList((Object[])obj2) : Arrays.asList(obj2);
        return lo.containsAll(arg);
    }

    @FunctionType(functionName="ATN", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double atn(double v) {
        return Math.atan(v);
    }

    @FunctionType(functionName="SQR", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double sqr(double v) {
        return Math.sqrt(v);
    }

    @FunctionType(functionName="CBOOL", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.YESNO)
    public static boolean cbool(BigDecimal value) {
        return Functions.cbool((Object)value);
    }

    @FunctionType(functionName="CBOOL", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean cbool(Boolean value) {
        return Functions.cbool((Object)value);
    }

    private static boolean cbool(Object obj) {
        boolean r = obj instanceof Boolean ? (Boolean)obj : (obj instanceof String ? Boolean.valueOf((String)obj) : (obj instanceof Number ? ((Number)obj).doubleValue() != 0.0 : false));
        return r;
    }

    @FunctionType(functionName="CBOOL", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean cbool(String value) {
        return Functions.cbool((Object)value);
    }

    @FunctionType(functionName="CCUR", argumentTypes={TypesMap.AccessType.CURRENCY}, returnType=TypesMap.AccessType.CURRENCY)
    public static BigDecimal ccur(BigDecimal value) throws UcanaccessSQLException {
        return value.setScale(4, 4);
    }

    @FunctionType(functionName="CDATE", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp cdate(String dt) {
        return Functions.dateValue(dt, false);
    }

    @FunctionType(functionName="CDBL", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double cdbl(Double value) throws UcanaccessSQLException {
        return value;
    }

    @FunctionType(functionName="CDEC", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double cdec(Double value) throws UcanaccessSQLException {
        return value;
    }

    @FunctionType(functionName="CINT", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.INTEGER)
    public static Short cint(Double value) throws UcanaccessSQLException {
        return new BigDecimal((long)Math.floor(value + 0.499999999999999)).shortValueExact();
    }

    @FunctionType(functionName="CINT", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.INTEGER)
    public static Short cint(boolean value) throws UcanaccessSQLException {
        return (short)(value ? -1 : 0);
    }

    @FunctionType(functionName="CLONG", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.LONG)
    public static Integer clong(Double value) throws UcanaccessSQLException {
        return Functions.clng(value);
    }

    @FunctionType(functionName="CLONG", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer clong(Integer value) throws UcanaccessSQLException {
        return value;
    }

    @FunctionType(functionName="CLNG", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.LONG)
    public static Integer clng(Double value) throws UcanaccessSQLException {
        return (int)Math.floor(value + 0.5);
    }

    @FunctionType(functionName="CLNG", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer clng(String value) throws UcanaccessSQLException {
        DecimalFormat dc = new DecimalFormat();
        try {
            return Functions.clng(dc.parse(value).doubleValue());
        }
        catch (ParseException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @FunctionType(functionName="CLNG", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer clng(Integer value) throws UcanaccessSQLException {
        return value;
    }

    @FunctionType(functionName="CLONG", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.LONG)
    public static Integer clong(boolean value) throws UcanaccessSQLException {
        return value ? -1 : 0;
    }

    @FunctionType(functionName="CSIGN", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.SINGLE)
    public static double csign(double value) {
        MathContext mc = new MathContext(7);
        return new BigDecimal(value, mc).doubleValue();
    }

    @FunctionType(functionName="CSTR", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(Boolean value) throws UcanaccessSQLException {
        return Functions.cstr((Object)value);
    }

    @FunctionType(functionName="CSTR", argumentTypes={TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(String value) throws UcanaccessSQLException {
        return value;
    }

    @FunctionType(functionName="CSTR", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(double value) throws UcanaccessSQLException {
        return Functions.cstr((Object)value);
    }

    @FunctionType(functionName="CSTR", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(int value) throws UcanaccessSQLException {
        return Functions.cstr((Object)value);
    }

    public static String cstr(Object value) throws UcanaccessSQLException {
        return value == null ? null : Functions.format(value.toString(), "", true);
    }

    @FunctionType(functionName="CSTR", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.MEMO)
    public static String cstr(Timestamp value) throws UcanaccessSQLException {
        return value == null ? null : Functions.format(value, "general date");
    }

    @FunctionType(functionName="CVAR", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.MEMO)
    public static String cvar(Double value) throws UcanaccessSQLException {
        return Functions.format(value, "general number");
    }

    @FunctionType(namingConflict=true, functionName="DATEADD", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static java.util.Date dateAdd(String intv, int vl, java.util.Date dt) throws UcanaccessSQLException {
        if (dt == null || intv == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(dt);
        if (intv.equalsIgnoreCase("yyyy")) {
            cl.add(1, vl);
        } else if (intv.equalsIgnoreCase("q")) {
            cl.add(2, vl * 3);
        } else if (intv.equalsIgnoreCase("y") || intv.equalsIgnoreCase("d")) {
            cl.add(6, vl);
        } else if (intv.equalsIgnoreCase("m")) {
            cl.add(2, vl);
        } else if (intv.equalsIgnoreCase("w")) {
            cl.add(7, vl);
        } else if (intv.equalsIgnoreCase("ww")) {
            cl.add(3, vl);
        } else if (intv.equalsIgnoreCase("h")) {
            cl.add(10, vl);
        } else if (intv.equalsIgnoreCase("n")) {
            cl.add(12, vl);
        } else if (intv.equalsIgnoreCase("s")) {
            cl.add(13, vl);
        } else {
            throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.INVALID_INTERVAL_VALUE);
        }
        return dt instanceof Timestamp ? new Timestamp(cl.getTimeInMillis()) : new Date(cl.getTimeInMillis());
    }

    @FunctionType(namingConflict=true, functionName="DATEADD", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateAdd(String intv, int vl, Timestamp dt) throws UcanaccessSQLException {
        return (Timestamp)Functions.dateAdd(intv, vl, (java.util.Date)dt);
    }

    @FunctionType(namingConflict=true, functionName="DATEADD", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateAdd(String intv, int vl, String dt) throws UcanaccessSQLException {
        return (Timestamp)Functions.dateAdd(intv, vl, (java.util.Date)Functions.dateValue(dt, false));
    }

    @FunctionType(namingConflict=true, functionName="DATEDIFF", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String intv, String dt1, String dt2) throws UcanaccessSQLException {
        return Functions.dateDiff(intv, Functions.dateValue(dt1, false), Functions.dateValue(dt2, false));
    }

    @FunctionType(namingConflict=true, functionName="DATEDIFF", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String intv, String dt1, Timestamp dt2) throws UcanaccessSQLException {
        return Functions.dateDiff(intv, Functions.dateValue(dt1, false), dt2);
    }

    @FunctionType(namingConflict=true, functionName="DATEDIFF", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String intv, Timestamp dt1, String dt2) throws UcanaccessSQLException {
        return Functions.dateDiff(intv, dt1, Functions.dateValue(dt2, false));
    }

    @FunctionType(namingConflict=true, functionName="DATEDIFF", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer dateDiff(String intv, Timestamp dt1, Timestamp dt2) throws UcanaccessSQLException {
        Integer result;
        int sign;
        if (dt1 == null || intv == null || dt2 == null) {
            return null;
        }
        Calendar clMin = Calendar.getInstance();
        Calendar clMax = Calendar.getInstance();
        int n = sign = dt1.after(dt2) ? -1 : 1;
        if (sign == 1) {
            clMax.setTime(dt2);
            clMin.setTime(dt1);
        } else {
            clMax.setTime(dt1);
            clMin.setTime(dt2);
        }
        clMin.set(14, 0);
        clMax.set(14, 0);
        if (intv.equalsIgnoreCase("yyyy")) {
            result = clMax.get(1) - clMin.get(1);
        } else if (intv.equalsIgnoreCase("q")) {
            result = Functions.dateDiff("yyyy", dt1, dt2) * 4 + (clMax.get(2) - clMin.get(2)) / 3;
        } else if (intv.equalsIgnoreCase("y") || intv.equalsIgnoreCase("d")) {
            result = (int)Math.rint((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 8.64E7);
        } else if (intv.equalsIgnoreCase("m")) {
            result = Functions.dateDiff("yyyy", dt1, dt2) * 12 + (clMax.get(2) - clMin.get(2));
        } else if (intv.equalsIgnoreCase("w") || intv.equalsIgnoreCase("ww")) {
            result = (int)Math.floor((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 6.048E8);
        } else if (intv.equalsIgnoreCase("h")) {
            result = (int)Math.round((double)(clMax.getTime().getTime() - clMin.getTime().getTime()) / 3600000.0);
        } else if (intv.equalsIgnoreCase("n")) {
            result = (int)Math.rint((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 60000.0);
        } else if (intv.equalsIgnoreCase("s")) {
            result = (int)Math.rint((double)(clMax.getTimeInMillis() - clMin.getTimeInMillis()) / 1000.0);
        } else {
            throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.INVALID_INTERVAL_VALUE);
        }
        return result * sign;
    }

    @FunctionType(namingConflict=true, functionName="DATEPART", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String intv, String dt, Integer firstDayOfWeek) throws UcanaccessSQLException {
        return Functions.datePart(intv, Functions.dateValue(dt, false), firstDayOfWeek);
    }

    @FunctionType(namingConflict=true, functionName="DATEPART", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String intv, Timestamp dt, Integer firstDayOfWeek) throws UcanaccessSQLException {
        Integer ret;
        Integer n = ret = intv.equalsIgnoreCase("ww") ? Functions.datePart(intv, dt, firstDayOfWeek, (Integer)1) : Functions.datePart(intv, dt);
        if (intv.equalsIgnoreCase("w") && firstDayOfWeek > 1) {
            Calendar cl = Calendar.getInstance();
            cl.setTime(dt);
            ret = cl.get(7) - firstDayOfWeek + 1;
            if (ret <= 0) {
                ret = ret + 7;
            }
        }
        return ret;
    }

    @FunctionType(namingConflict=true, functionName="DATEPART", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String intv, String dt, Integer firstDayOfWeek, Integer firstWeekOfYear) throws UcanaccessSQLException {
        return Functions.datePart(intv, Functions.dateValue(dt, false), firstDayOfWeek, firstWeekOfYear);
    }

    @FunctionType(namingConflict=true, functionName="DATEPART", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String intv, Timestamp dt, Integer firstDayOfWeek, Integer firstWeekOfYear) throws UcanaccessSQLException {
        Integer ret = Functions.datePart(intv, dt);
        if (intv.equalsIgnoreCase("ww") && (firstWeekOfYear > 1 || firstDayOfWeek > 1)) {
            int dow;
            Calendar cl = Calendar.getInstance();
            cl.setTime(dt);
            cl.set(2, 0);
            cl.set(5, 1);
            Calendar cl1 = Calendar.getInstance();
            cl1.setTime(dt);
            if (firstDayOfWeek == 0) {
                firstDayOfWeek = 1;
            }
            if ((dow = cl.get(7) - firstDayOfWeek + 1) <= 0) {
                dow += 7;
                if (cl1.get(7) - firstDayOfWeek >= 0) {
                    ret = ret + 1;
                }
            }
            if (dow > 4 && firstWeekOfYear == 2) {
                ret = ret - 1;
            }
            if (dow > 1 && firstWeekOfYear == 3) {
                ret = ret - 1;
            }
        }
        return ret;
    }

    @FunctionType(namingConflict=true, functionName="DATEPART", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String intv, String dt) throws UcanaccessSQLException {
        return Functions.datePart(intv, Functions.dateValue(dt, false));
    }

    @FunctionType(namingConflict=true, functionName="DATEPART", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer datePart(String intv, Timestamp dt) throws UcanaccessSQLException {
        if (dt == null || intv == null) {
            return null;
        }
        Calendar cl = Calendar.getInstance(Locale.US);
        cl.setTime(dt);
        if (intv.equalsIgnoreCase("yyyy")) {
            return cl.get(1);
        }
        if (intv.equalsIgnoreCase("q")) {
            return (int)Math.ceil((double)(cl.get(2) + 1) / 3.0);
        }
        if (intv.equalsIgnoreCase("d")) {
            return cl.get(5);
        }
        if (intv.equalsIgnoreCase("y")) {
            return cl.get(6);
        }
        if (intv.equalsIgnoreCase("m")) {
            return cl.get(2) + 1;
        }
        if (intv.equalsIgnoreCase("ww")) {
            return cl.get(3);
        }
        if (intv.equalsIgnoreCase("w")) {
            return cl.get(7);
        }
        if (intv.equalsIgnoreCase("h")) {
            return cl.get(11);
        }
        if (intv.equalsIgnoreCase("n")) {
            return cl.get(12);
        }
        if (intv.equalsIgnoreCase("s")) {
            return cl.get(13);
        }
        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.INVALID_INTERVAL_VALUE);
    }

    @FunctionType(functionName="DATESERIAL", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateSerial(int year, int month, int day) {
        Calendar cl = Calendar.getInstance();
        cl.setLenient(true);
        cl.set(1, year);
        cl.set(2, month - 1);
        cl.set(5, day);
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        return new Timestamp(cl.getTime().getTime());
    }

    @FunctionType(functionName="DATEVALUE", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateValue(String dt) {
        return Functions.dateValue(dt, true);
    }

    private static Timestamp dateValue(String dt, boolean onlyDate) {
        if (!("true".equalsIgnoreCase(reg.getRS()) || "PM".equalsIgnoreCase(reg.getPM()) && "AM".equalsIgnoreCase(reg.getAM()))) {
            dt = dt.replaceAll("(?i)" + Pattern.quote(reg.getPM()), "PM").replaceAll("(?i)" + Pattern.quote(reg.getAM()), "AM");
        }
        for (SimpleDateFormat sdf : LDF) {
            try {
                Timestamp t = new Timestamp(sdf.parse(dt).getTime());
                if (onlyDate) {
                    t = Functions.dateValue(t);
                }
                if (LDFY.get(LDF.indexOf(sdf)).booleanValue()) {
                    Calendar cl = Calendar.getInstance();
                    int y = cl.get(1);
                    cl.setTime(t);
                    cl.set(1, y);
                    t = new Timestamp(cl.getTime().getTime());
                }
                return t;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @FunctionType(functionName="DATEVALUE", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp dateValue(Timestamp dt) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(dt);
        cl.set(11, 0);
        cl.set(12, 0);
        cl.set(13, 0);
        cl.set(14, 0);
        return new Timestamp(cl.getTime().getTime());
    }

    @FunctionType(functionName="FORMAT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.TEXT)
    public static String format(double d, String par) throws UcanaccessSQLException {
        if ("percent".equalsIgnoreCase(par)) {
            DecimalFormat formatter = new DecimalFormat("0.00");
            formatter.setRoundingMode(RoundingMode.HALF_UP);
            return String.valueOf(formatter.format(d * 100.0)) + "%";
        }
        if ("fixed".equalsIgnoreCase(par)) {
            DecimalFormat formatter = new DecimalFormat("0.00");
            formatter.setRoundingMode(RoundingMode.HALF_UP);
            return formatter.format(d);
        }
        if ("standard".equalsIgnoreCase(par)) {
            DecimalFormat formatter = new DecimalFormat("###,###.##");
            return formatter.format(d);
        }
        if ("general number".equalsIgnoreCase(par)) {
            DecimalFormat formatter = new DecimalFormat();
            formatter.setGroupingUsed(false);
            return formatter.format(d);
        }
        if ("yes/no".equalsIgnoreCase(par)) {
            return d == 0.0 ? "No" : "Yes";
        }
        if ("true/false".equalsIgnoreCase(par)) {
            return d == 0.0 ? "False" : "True";
        }
        if ("On/Off".equalsIgnoreCase(par)) {
            return d == 0.0 ? "Off" : "On";
        }
        if ("Scientific".equalsIgnoreCase(par)) {
            return String.format("%6.2E", d);
        }
        try {
            DecimalFormat formatter = new DecimalFormat(par);
            formatter.setRoundingMode(RoundingMode.HALF_UP);
            return formatter.format(d);
        }
        catch (Exception e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @FunctionType(functionName="FORMAT", argumentTypes={TypesMap.AccessType.TEXT, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.TEXT)
    public static String format(String s, String par) throws UcanaccessSQLException {
        return Functions.format(s, par, false);
    }

    public static String format(String s, String par, boolean incl) throws UcanaccessSQLException {
        if (Functions.isNumeric(s)) {
            if (incl) {
                return Functions.format(Double.parseDouble(s), par);
            }
            DecimalFormat df = new DecimalFormat();
            try {
                return Functions.format(df.parse(s).doubleValue(), par);
            }
            catch (ParseException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        if (Functions.isDate(s)) {
            return Functions.format(Functions.dateValue(s, false), par);
        }
        return s;
    }

    private static String formatDate(Timestamp t, String pattern) {
        String ret = new SimpleDateFormat(pattern).format(t);
        if (!reg.getRS().equalsIgnoreCase("true")) {
            if (!reg.getAM().equals("AM")) {
                ret = ret.replaceAll("AM", reg.getAM());
            }
            if (!reg.getPM().equals("PM")) {
                ret = ret.replaceAll("PM", reg.getPM());
            }
        } else {
            ret = ret.replaceAll(reg.getPM(), "PM");
            ret = ret.replaceAll(reg.getAM(), "AM");
        }
        return ret;
    }

    @FunctionType(functionName="FORMAT", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.TEXT)
    public static String format(Timestamp t, String par) throws UcanaccessSQLException {
        if ("long date".equalsIgnoreCase(par)) {
            return Functions.formatDate(t, reg.getLongDatePattern());
        }
        if ("medium date".equalsIgnoreCase(par)) {
            return Functions.formatDate(t, reg.getMediumDatePattern());
        }
        if ("short date".equalsIgnoreCase(par)) {
            return Functions.formatDate(t, reg.getShortDatePattern());
        }
        if ("general date".equalsIgnoreCase(par)) {
            return Functions.formatDate(t, reg.getGeneralPattern());
        }
        if ("long time".equalsIgnoreCase(par)) {
            return Functions.formatDate(t, reg.getLongTimePattern());
        }
        if ("medium time".equalsIgnoreCase(par)) {
            return Functions.formatDate(t, reg.getMediumTimePattern());
        }
        if ("short time".equalsIgnoreCase(par)) {
            return Functions.formatDate(t, reg.getShortTimePattern());
        }
        if ("q".equalsIgnoreCase(par)) {
            return String.valueOf(Functions.datePart(par, t));
        }
        return new SimpleDateFormat(par.replaceAll("m", "M").replaceAll("n", "m").replaceAll("(?i)AM/PM|A/P|AMPM", "a").replaceAll("dddd", "EEEE")).format(t);
    }

    @FunctionType(functionName="IIF", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String iif(boolean b, String o, String o1) {
        return (String)Functions.iif((Boolean)b, (Object)o, (Object)o1);
    }

    @FunctionType(functionName="IIF", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer iif(boolean b, Integer o, Integer o1) {
        return (Integer)Functions.iif((Boolean)b, (Object)o, (Object)o1);
    }

    @FunctionType(functionName="IIF", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double iif(boolean b, Double o, Double o1) {
        return (Double)Functions.iif((Boolean)b, (Object)o, (Object)o1);
    }

    @FunctionType(functionName="IIF", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.YESNO, TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean iif(Boolean b, Boolean o, Boolean o1) {
        return (Boolean)Functions.iif(b, (Object)o, (Object)o1);
    }

    @FunctionType(functionName="IIF", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.DATETIME, TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp iif(Boolean b, Timestamp o, Timestamp o1) {
        return (Timestamp)Functions.iif(b, (Object)o, (Object)o1);
    }

    private static Object iif(Boolean b, Object o, Object o1) {
        if (b == null) {
            b = Boolean.FALSE;
        }
        return b != false ? o : o1;
    }

    @FunctionType(namingConflict=true, functionName="INSTR", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(Integer start, String text, String search) {
        return Functions.instr(start, text, search, -1);
    }

    @FunctionType(namingConflict=true, functionName="INSTR", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(Integer start, String text, String search, Integer compare) {
        start = start - 1;
        if (compare != 0) {
            text = text.toLowerCase();
        }
        if (text.length() <= start) {
            return 0;
        }
        text = text.substring(start);
        return text.indexOf(search) + start + 1;
    }

    @FunctionType(namingConflict=true, functionName="INSTR", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(String text, String search) {
        return Functions.instr(1, text, search, -1);
    }

    @FunctionType(namingConflict=true, functionName="INSTR", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instr(String text, String search, Integer compare) {
        return Functions.instr(1, text, search, compare);
    }

    @FunctionType(functionName="INSTRREV", argumentTypes={TypesMap.AccessType.TEXT, TypesMap.AccessType.TEXT}, returnType=TypesMap.AccessType.LONG)
    public static Integer instrrev(String text, String search) {
        return Functions.instrrev(text, search, -1, -1);
    }

    @FunctionType(functionName="INSTRREV", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instrrev(String text, String search, Integer start) {
        return Functions.instrrev(text, search, start, -1);
    }

    @FunctionType(functionName="INSTRREV", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer instrrev(String text, String search, Integer start, Integer compare) {
        if (compare != 0) {
            text = text.toLowerCase();
        }
        if (text.length() <= start) {
            return 0;
        }
        if (start > 0) {
            text = text.substring(0, start);
        }
        return text.lastIndexOf(search) + 1;
    }

    @FunctionType(functionName="ISDATE", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isDate(String dt) {
        return Functions.dateValue(dt) != null;
    }

    @FunctionType(functionName="ISDATE", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isDate(Timestamp dt) {
        return true;
    }

    @FunctionType(namingConflict=true, functionName="IsNull", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNull(String o) {
        return o == null;
    }

    @FunctionType(namingConflict=true, functionName="IsNull", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNull(Timestamp o) {
        return o == null;
    }

    @FunctionType(namingConflict=true, functionName="IsNull", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNull(Double o) {
        return o == null;
    }

    @FunctionType(functionName="ISNUMERIC", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNumeric(BigDecimal b) {
        return true;
    }

    @FunctionType(functionName="ISNUMERIC", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static boolean isNumeric(String s) {
        String gs;
        String sep;
        block6: {
            try {
                Currency cr = Currency.getInstance(Locale.getDefault());
                if (s.startsWith(cr.getSymbol())) {
                    return Functions.isNumeric(s.substring(cr.getSymbol().length()));
                }
                if (s.startsWith("+") || s.startsWith("-")) {
                    return Functions.isNumeric(s.substring(1));
                }
                DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
                sep = String.valueOf(dfs.getDecimalSeparator());
                gs = String.valueOf(dfs.getGroupingSeparator());
                if (!s.startsWith(gs)) break block6;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (s.startsWith(sep)) {
            return Functions.isNumeric(s.substring(1));
        }
        s = sep.equals(".") ? s.replaceAll(gs, "") : s.replaceAll("\\.", "").replaceAll(sep, ".");
        new BigDecimal(s);
        return true;
    }

    @FunctionType(functionName="LEN", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer len(String o) {
        if (o == null) {
            return null;
        }
        return new Integer(o.length());
    }

    @FunctionType(functionName="MID", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String mid(String value, int start) {
        return Functions.mid(value, start, value.length());
    }

    @FunctionType(functionName="MID", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String mid(String value, int start, int length) {
        if (value == null) {
            return null;
        }
        int len = start - 1 + length;
        if (start < 1) {
            throw new RuntimeException("Invalid function call");
        }
        if (len > value.length()) {
            len = value.length();
        }
        return value.substring(start - 1, len);
    }

    @FunctionType(namingConflict=true, functionName="MONTHNAME", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.TEXT)
    public static String monthName(int i) throws UcanaccessSQLException {
        return Functions.monthName(i, false);
    }

    @FunctionType(namingConflict=true, functionName="MONTHNAME", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.TEXT)
    public static String monthName(int i, boolean abbr) throws UcanaccessSQLException {
        if (--i >= 0 && i <= 11) {
            DateFormatSymbols dfs = new DateFormatSymbols();
            return abbr ? dfs.getShortMonths()[i] : dfs.getMonths()[i];
        }
        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.INVALID_MONTH_NUMBER);
    }

    @FunctionType(functionName="DATE", argumentTypes={}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp date() {
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        cl.set(13, 0);
        cl.set(12, 0);
        cl.set(11, 0);
        return new Timestamp(cl.getTime().getTime());
    }

    @FunctionType(namingConflict=true, functionName="NOW", argumentTypes={}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp now() {
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        return new Timestamp(cl.getTime().getTime());
    }

    private static Object nz(Object value, Object outher) {
        return value == null ? outher : value;
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String nz(String value) {
        return value == null ? "" : value;
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double nz(Double value) {
        return value == null ? 0.0 : value;
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer nz(Integer value) {
        return value == null ? 0 : value;
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.NUMERIC)
    public static BigDecimal nz(BigDecimal value) {
        return value == null ? new BigDecimal(0) : value;
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String nz(String value, String outher) {
        return (String)Functions.nz((Object)value, (Object)outher);
    }

    @FunctionType(functionName="SIGN", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.INTEGER)
    public static short sign(double n) {
        return (short)(n == 0.0 ? 0 : (n > 0.0 ? 1 : -1));
    }

    @FunctionType(functionName="SPACE", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String space(Integer nr) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < nr) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    @FunctionType(functionName="STR", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.TEXT)
    public static String str(double d) {
        String pre = d > 0.0 ? " " : "";
        return (double)Math.round(d) == d ? String.valueOf(pre) + Math.round(d) : String.valueOf(pre) + d;
    }

    @FunctionType(functionName="TIME", argumentTypes={}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp time() {
        Calendar cl = Calendar.getInstance();
        cl.setTime(Functions.now());
        cl.set(1899, 11, 30);
        return new Timestamp(cl.getTimeInMillis());
    }

    @FunctionType(functionName="VAL", argumentTypes={TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double val(BigDecimal val1) {
        return Functions.val((Object)val1);
    }

    private static Double val(Object val1) {
        if (val1 == null) {
            return null;
        }
        String val = val1.toString().trim();
        int lp = val.lastIndexOf(".");
        char[] ca = val.toCharArray();
        StringBuffer sb = new StringBuffer();
        int minLength = 1;
        int i = 0;
        while (i < ca.length) {
            char c = ca[i];
            if ((c == '-' || c == '+') && i == 0) {
                ++minLength;
                sb.append(c);
            } else if (c != ' ') {
                if (Character.isDigit(c)) {
                    sb.append(c);
                } else {
                    if (c != '.' || i != lp) break;
                    sb.append(c);
                    if (i == 0 || i == 1 && minLength == 2) {
                        ++minLength;
                    }
                }
            }
            ++i;
        }
        if (sb.length() < minLength) {
            return 0.0;
        }
        return Double.parseDouble(sb.toString());
    }

    @FunctionType(functionName="VAL", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double val(String val1) {
        return Functions.val((Object)val1);
    }

    @FunctionType(functionName="WEEKDAYNAME", argumentTypes={TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.TEXT)
    public static String weekDayName(int i) {
        return Functions.weekDayName(i, false);
    }

    @FunctionType(functionName="WEEKDAYNAME", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.TEXT)
    public static String weekDayName(int i, boolean abbr) {
        return Functions.weekDayName(i, abbr, 1);
    }

    @FunctionType(functionName="WEEKDAYNAME", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.YESNO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.TEXT)
    public static String weekDayName(int i, boolean abbr, int s) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, i + s - 1);
        String pattern = abbr ? "%ta" : "%tA";
        return String.format(pattern, cal, cal);
    }

    @FunctionType(functionName="WEEKDAY", argumentTypes={TypesMap.AccessType.DATETIME}, returnType=TypesMap.AccessType.LONG)
    public static Integer weekDay(Timestamp dt) throws UcanaccessSQLException {
        return Functions.datePart("w", dt);
    }

    @FunctionType(functionName="WEEKDAY", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer weekDay(Timestamp dt, Integer firstDayOfWeek) throws UcanaccessSQLException {
        return Functions.datePart("w", dt, firstDayOfWeek);
    }

    @FunctionType(functionName="STRING", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String string(Integer nr, String str) throws UcanaccessSQLException {
        if (str == null) {
            return null;
        }
        String ret = "";
        int i = 0;
        while (i < nr) {
            ret = String.valueOf(ret) + str.charAt(0);
            ++i;
        }
        return ret;
    }

    @FunctionType(functionName="TIMESERIAL", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp timeserial(Integer h, Integer m, Integer s) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(Functions.now());
        cl.set(1899, 11, 30, h, m, s);
        return new Timestamp(cl.getTimeInMillis());
    }

    @FunctionType(functionName="RND", argumentTypes={}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double rnd() {
        return Functions.rnd(null);
    }

    @FunctionType(functionName="RND", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double rnd(Double d) {
        if (d == null) {
            lastRnd = Math.random();
            return lastRnd;
        }
        if (d > 0.0) {
            lastRnd = Math.random();
            return lastRnd;
        }
        if (d < 0.0) {
            return rnd == null ? (rnd = d) : rnd;
        }
        if (d == 0.0) {
            return lastRnd == null ? (lastRnd = Double.valueOf(Math.random())) : lastRnd;
        }
        return null;
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.NUMERIC, TypesMap.AccessType.NUMERIC}, returnType=TypesMap.AccessType.NUMERIC)
    public static BigDecimal nz(BigDecimal value, BigDecimal outher) {
        return (BigDecimal)Functions.nz((Object)value, (Object)outher);
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double nz(Double value, Double outher) {
        return (Double)Functions.nz((Object)value, (Object)outher);
    }

    @FunctionType(functionName="NZ", argumentTypes={TypesMap.AccessType.LONG, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer nz(Integer value, Integer outher) {
        return (Integer)Functions.nz((Object)value, (Object)outher);
    }

    @FunctionType(functionName="STRREVERSE", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String strReverse(String value) {
        if (value == null) {
            return null;
        }
        return new StringBuffer(value).reverse().toString();
    }

    @FunctionType(functionName="STRCONV", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.MEMO)
    public static String strConv(String value, int ul) {
        if (value == null) {
            return null;
        }
        if (ul == 1) {
            value = value.toUpperCase();
        }
        if (ul == 2) {
            value = value.toLowerCase();
        }
        return value;
    }

    @FunctionType(functionName="STRCOMP", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO, TypesMap.AccessType.LONG}, returnType=TypesMap.AccessType.LONG)
    public static Integer strComp(String value1, String value2, Integer type) throws UcanaccessSQLException {
        switch (type) {
            case -1: 
            case 0: 
            case 2: {
                return value1.compareTo(value2);
            }
            case 1: {
                return value1.toUpperCase().compareTo(value2.toUpperCase());
            }
        }
        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.INVALID_PARAMETER);
    }

    @FunctionType(functionName="STRCOMP", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.LONG)
    public static Integer strComp(String value1, String value2) throws UcanaccessSQLException {
        return Functions.strComp(value1, value2, 0);
    }

    @FunctionType(functionName="INT", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.LONG)
    public static Integer mint(Double value) throws UcanaccessSQLException {
        return new BigDecimal((long)Math.floor(value)).intValueExact();
    }

    @FunctionType(functionName="INT", argumentTypes={TypesMap.AccessType.YESNO}, returnType=TypesMap.AccessType.INTEGER)
    public static Short mint(boolean value) throws UcanaccessSQLException {
        return (short)(value ? -1 : 0);
    }

    @FunctionType(functionName="DDB", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ddb(double cost, double salvage, double life, double period) {
        return Functions.ddb(cost, salvage, life, period, 2.0);
    }

    @FunctionType(functionName="DDB", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ddb(double cost, double salvage, double life, double period, double factor) {
        if (cost < 0.0 || life == 2.0 && period > 1.0) {
            return 0.0;
        }
        if (life < 2.0 || life == 2.0 && period <= 1.0) {
            return cost - salvage;
        }
        if (period <= 1.0) {
            return Math.min(cost * factor / life, cost - salvage);
        }
        double retk = Math.max(salvage - cost * Math.pow((life - factor) / life, period), 0.0);
        return Math.max(factor * cost / life * Math.pow((life - factor) / life, period - 1.0) - retk, 0.0);
    }

    @FunctionType(functionName="FV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double fv(double rate, int periods, double payment) {
        return Functions.fv(rate, periods, payment, 0.0, 0.0);
    }

    @FunctionType(functionName="FV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double fv(double rate, int periods, double payment, double pv) {
        return Functions.fv(rate, periods, payment, pv, 0.0);
    }

    @FunctionType(functionName="FV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double fv(double rate, int periods, double payment, double pv, double type) {
        type = Math.abs(type) >= 1.0 ? 1 : 0;
        double fv = pv * Math.pow(1.0 + rate, periods);
        int i = 0;
        while (i < periods) {
            fv += payment * Math.pow(1.0 + rate, (double)i + type);
            ++i;
        }
        return -fv;
    }

    @FunctionType(functionName="PMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pmt(double rate, double periods, double pv) {
        return Functions.pmt(rate, periods, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="PMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pmt(double rate, double periods, double pv, double fv) {
        return Functions.pmt(rate, periods, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="PMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pmt(double rate, double periods, double pv, double fv, double type) {
        type = Math.abs(type) >= 1.0 ? 1 : 0;
        if (rate == 0.0) {
            return -1.0 * (fv + pv) / periods;
        }
        return (fv + pv * Math.pow(1.0 + rate, periods)) * rate / ((type == 1.0 ? 1.0 + rate : 1.0) * (1.0 - Math.pow(1.0 + rate, periods)));
    }

    @FunctionType(functionName="NPER", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double nper(double rate, double pmt, double pv) {
        return Functions.nper(rate, pmt, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="NPER", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double nper(double rate, double pmt, double pv, double fv) {
        return Functions.nper(rate, pmt, pv, fv, 0.0);
    }

    @FunctionType(functionName="NPER", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double nper(double rate, double pmt, double pv, double fv, double type) {
        type = Math.abs(type) >= 1.0 ? 1 : 0;
        double nper = 0.0;
        if (rate == 0.0) {
            nper = -1.0 * (fv + pv) / pmt;
        } else {
            double cr = (type == 1.0 ? 1.0 + rate : 1.0) * pmt / rate;
            double val1 = cr - fv < 0.0 ? Math.log(fv - cr) : Math.log(cr - fv);
            double val2 = cr - fv < 0.0 ? Math.log(-pv - cr) : Math.log(pv + cr);
            double val3 = Math.log(1.0 + rate);
            nper = (val1 - val2) / val3;
        }
        return nper;
    }

    @FunctionType(functionName="IPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ipmt(double rate, double per, double nper, double pv) {
        return Functions.ipmt(rate, per, nper, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="IPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ipmt(double rate, double per, double nper, double pv, double fv) {
        return Functions.ipmt(rate, per, nper, pv, fv, 0.0);
    }

    @FunctionType(functionName="IPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ipmt(double rate, double per, double nper, double pv, double fv, double type) {
        type = Math.abs(type) >= 1.0 ? 1 : 0;
        double ipmt = Functions.fv(rate, new Double(per).intValue() - 1, Functions.pmt(rate, nper, pv, fv, type), pv, type) * rate;
        if (type == 1.0) {
            ipmt /= 1.0 + rate;
        }
        return ipmt;
    }

    @FunctionType(functionName="PV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pv(double rate, double nper, double pmt) {
        return Functions.pv(rate, nper, pmt, 0.0, 0.0);
    }

    @FunctionType(functionName="PV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pv(double rate, double nper, double pmt, double fv) {
        return Functions.pv(rate, nper, pmt, fv, 0.0);
    }

    @FunctionType(functionName="PV", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double pv(double rate, double nper, double pmt, double fv, double type) {
        type = Math.abs(type) >= 1.0 ? 1 : 0;
        if (rate == 0.0) {
            return -1.0 * (nper * pmt + fv);
        }
        return ((1.0 - Math.pow(1.0 + rate, nper)) / rate * (type == 1.0 ? 1.0 + rate : 1.0) * pmt - fv) / Math.pow(1.0 + rate, nper);
    }

    @FunctionType(functionName="PPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ppmt(double rate, int per, int nper, double pv) {
        return Functions.ppmt(rate, per, nper, pv, 0.0, 0.0);
    }

    @FunctionType(functionName="PPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ppmt(double rate, int per, int nper, double pv, double fv) {
        return Functions.ppmt(rate, per, nper, pv, fv, 0.0);
    }

    @FunctionType(functionName="PPMT", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.LONG, TypesMap.AccessType.LONG, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double ppmt(double rate, int per, int nper, double pv, double fv, double type) {
        return Functions.pmt(rate, nper, pv, fv, type) - Functions.ipmt(rate, per, nper, pv, fv, type);
    }

    @FunctionType(functionName="SLN", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double sln(double cost, double salvage, double life) {
        return (cost - salvage) / life;
    }

    @FunctionType(functionName="SYD", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double syd(double cost, double salvage, double life, double per) {
        return (cost - salvage) * (life - per + 1.0) * 2.0 / (life * (life + 1.0));
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv) {
        return Functions.rate(nper, pmt, pv, 0.0, 0.0, 0.1);
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv, double fv) {
        return Functions.rate(nper, pmt, pv, fv, 0.0, 0.1);
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv, double fv, double type) {
        return Functions.rate(nper, pmt, pv, fv, type, 0.1);
    }

    @FunctionType(functionName="RATE", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double rate(double nper, double pmt, double pv, double fv, double type, double guess) {
        double y;
        type = Math.abs(type) >= 1.0 ? 1 : 0;
        int FINANCIAL_MAX_ITERATIONS = 20;
        double FINANCIAL_PRECISION = 1.0E-7;
        double x1 = 0.0;
        double f = 0.0;
        double i = 0.0;
        double rate = guess;
        if (Math.abs(rate) < FINANCIAL_PRECISION) {
            y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * type) * nper + fv;
        } else {
            f = Math.exp(nper * Math.log(1.0 + rate));
            y = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
        }
        double y0 = pv + pmt * nper + fv;
        double y1 = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
        double x0 = 0.0;
        i = 0.0;
        x1 = rate;
        while (Math.abs(y0 - y1) > FINANCIAL_PRECISION && i < (double)FINANCIAL_MAX_ITERATIONS) {
            rate = (y1 * x0 - y0 * x1) / (y1 - y0);
            x0 = x1;
            x1 = rate;
            if (Math.abs(rate) < FINANCIAL_PRECISION) {
                y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * type) * nper + fv;
            } else {
                f = Math.exp(nper * Math.log(1.0 + rate));
                y = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
            }
            y0 = y1;
            y1 = y;
            i += 1.0;
        }
        return rate;
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(Double res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(Boolean res, String datatype) {
        if (res == null) {
            return null;
        }
        return res != false ? -1.0 : 0.0;
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(String res, String datatype) {
        if (res == null) {
            return null;
        }
        try {
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
            String sep = String.valueOf(dfs.getDecimalSeparator());
            String gs = String.valueOf(dfs.getGroupingSeparator());
            res = res.replaceAll(Pattern.quote(gs), "");
            if (!sep.equalsIgnoreCase(".")) {
                res = res.replaceAll(Pattern.quote(sep), ".");
            }
            double d = Functions.val(res);
            DataType dt = DataType.valueOf((String)datatype);
            if (dt.equals((Object)DataType.BYTE) || dt.equals((Object)DataType.INT) || dt.equals((Object)DataType.LONG)) {
                d = Math.rint(d + 1.0E-8);
            }
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    @FunctionType(functionName="formulaToNumeric", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DOUBLE)
    public static Double formulaToNumeric(Timestamp res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        Calendar clbb = Calendar.getInstance();
        clbb.set(1899, 11, 30, 0, 0, 0);
        return (double)Functions.dateDiff("y", new Timestamp(clbb.getTimeInMillis()), res);
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(Boolean res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(Double res, String datatype) {
        if (res == null) {
            return null;
        }
        if (res != 0.0) {
            return true;
        }
        return false;
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(Timestamp res, String datatype) {
        return null;
    }

    @FunctionType(functionName="formulaToBoolean", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.YESNO)
    public static Boolean formulaToBoolean(String res, String datatype) {
        if (res == null) {
            return null;
        }
        if (res.equals("-1")) {
            return true;
        }
        if (res.equals("0")) {
            return false;
        }
        return null;
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(String res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(Double res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance();
        DecimalFormat df = new DecimalFormat("#", dfs);
        df.setGroupingUsed(false);
        df.setMaximumFractionDigits(100);
        return df.format(res);
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(Boolean res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        return res != false ? "-1" : "0";
    }

    @FunctionType(functionName="formulaToText", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String formulaToText(Timestamp res, String datatype) throws UcanaccessSQLException {
        Calendar cl = Calendar.getInstance();
        cl.setTimeInMillis(res.getTime());
        if (cl.get(10) == 0 && cl.get(12) == 0 && cl.get(13) == 0) {
            return Functions.format(res, "short date");
        }
        return Functions.format(res, "general date");
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.DATETIME, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(Timestamp res, String datatype) {
        return res;
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.MEMO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(String res, String datatype) {
        if (res == null) {
            return null;
        }
        try {
            return Functions.dateValue(res, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.YESNO, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(Boolean res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        Calendar clbb = Calendar.getInstance();
        clbb.set(1899, 11, 30, 0, 0, 0);
        clbb.set(14, 0);
        return Functions.dateAdd("y", res != false ? -1 : 0, new Timestamp(clbb.getTimeInMillis()));
    }

    @FunctionType(functionName="orderJet", argumentTypes={TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.MEMO)
    public static String orderJet(String s) {
        return s.replaceAll("([a-zA-Z0-9])[\\-\u2013\u2014]([a-zA-Z0-9])", "$1$2");
    }

    @FunctionType(functionName="formulaToDate", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.MEMO}, returnType=TypesMap.AccessType.DATETIME)
    public static Timestamp formulaToDate(Double res, String datatype) throws UcanaccessSQLException {
        if (res == null) {
            return null;
        }
        Calendar clbb = Calendar.getInstance();
        clbb.set(1899, 11, 30, 0, 0, 0);
        clbb.set(14, 0);
        Double d = Math.floor(res);
        Timestamp tr = Functions.dateAdd("y", d.intValue(), new Timestamp(clbb.getTimeInMillis()));
        d = (res - (double)res.intValue()) * 24.0;
        tr = Functions.dateAdd("H", d.intValue(), tr);
        d = (d - (double)d.intValue()) * 60.0;
        tr = Functions.dateAdd("N", d.intValue(), tr);
        d = (d - (double)d.intValue()) * 60.0;
        tr = Functions.dateAdd("S", new Double(Math.rint(d + 1.0E-8)).intValue(), tr);
        return tr;
    }

    @FunctionType(namingConflict=true, functionName="ROUND", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double round(double d, double p) {
        double f = Math.pow(10.0, p);
        return (double)Math.round(d * f) / f;
    }

    @FunctionType(namingConflict=true, functionName="FIX", argumentTypes={TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.DOUBLE)
    public static double fix(double d) throws UcanaccessSQLException {
        return Functions.sign(d) * Functions.mint(Math.abs(d));
    }

    @FunctionType(functionName="PARTITION", argumentTypes={TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE, TypesMap.AccessType.DOUBLE}, returnType=TypesMap.AccessType.MEMO)
    public static String partition(Double number, double start, double stop, double interval) throws UcanaccessSQLException {
        if (number == null) {
            return null;
        }
        number = Math.rint(number);
        interval = Math.rint(interval);
        String ul = String.valueOf(Functions.lrint(stop) + 1);
        stop = Functions.lrint(stop);
        start = Functions.lrint(start);
        int h = ul.length();
        if (number < start) {
            return String.valueOf(Functions.padLeft(-1, h)) + ":" + Functions.padLeft(Functions.lrint(start) - 1, h);
        }
        if (number > stop) {
            return String.valueOf(ul) + ":" + Functions.padLeft(-1, h);
        }
        double d = start;
        while (d <= stop) {
            if (number >= d && number < d + interval) {
                return String.valueOf(Functions.padLeft(Functions.lceil(d), h)) + ":" + Functions.padLeft(d + interval <= stop ? Functions.lfloor(d + interval) : Functions.lrint(stop), h);
            }
            d += interval;
        }
        return "";
    }

    private static int lfloor(double d) {
        return new Double(Math.floor(d - 1.0E-8)).intValue();
    }

    private static int lceil(double d) {
        return new Double(Math.ceil(d - 1.0E-8)).intValue();
    }

    private static int lrint(double d) {
        return new Double(Math.rint(d - 1.0E-8)).intValue();
    }

    private static String padLeft(int ext, int n) {
        String tp = ext > 0 ? String.valueOf(ext) : "";
        return String.format("%1$" + n + "s", tp);
    }
}

