/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.ucanaccess.commands.DDLCommandEnlist;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.Execute;
import net.ucanaccess.jdbc.FeatureNotSupportedException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessPreparedStatement;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessStatement;

public abstract class AbstractExecute {
    protected int autoGeneratedKeys;
    protected String[] columnNames;
    protected CommandType commandType;
    protected int[] indexes;
    private UcanaccessResultSet resultSet;
    protected String sql;
    private UcanaccessStatement statement;

    protected AbstractExecute(UcanaccessPreparedStatement statement) {
        this.statement = statement;
        this.commandType = CommandType.PREPARED_STATEMENT;
    }

    protected AbstractExecute(UcanaccessResultSet resultSet) {
        this.resultSet = resultSet;
        this.statement = resultSet.getWrappedStatement();
        this.commandType = CommandType.UPDATABLE_RESULTSET;
    }

    public AbstractExecute(UcanaccessStatement statement) {
        this.statement = statement;
    }

    protected AbstractExecute(UcanaccessStatement statement, String sql) {
        this(statement);
        this.commandType = CommandType.NO_ARGUMENTS;
        this.sql = sql;
    }

    protected AbstractExecute(UcanaccessStatement statement, String sql, int autoGeneratedKeys) {
        this(statement, sql);
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.commandType = CommandType.WITH_AUTO_GENERATED_KEYS;
    }

    protected AbstractExecute(UcanaccessStatement statement, String sql, int[] indexes) {
        this(statement, sql);
        this.indexes = indexes;
        this.commandType = CommandType.WITH_INDEXES;
    }

    protected AbstractExecute(UcanaccessStatement statement, String sql, String[] columnNames) {
        this(statement, sql);
        this.columnNames = columnNames;
        this.commandType = CommandType.WITH_COLUMNS_NAME;
    }

    private Object addDDLCommand() throws SQLException {
        Comparable<Boolean> ret;
        try {
            SQLConverter.DDLType ddlType = SQLConverter.getDDLType(this.sql);
            if (ddlType == null) {
                throw new FeatureNotSupportedException(FeatureNotSupportedException.NotSupportedMessage.NOT_SUPPORTED_YET);
            }
            String sql0 = SQLConverter.convertSQL(this.sql);
            String ddlExpr = ddlType.in(SQLConverter.DDLType.CREATE_TABLE, SQLConverter.DDLType.CREATE_TABLE_AS_SELECT) ? SQLConverter.convertCreateTable(sql0) : sql0;
            ret = this instanceof Execute ? (Comparable<Boolean>)Boolean.valueOf(this.statement.getWrapped().execute(ddlExpr)) : (Comparable<Boolean>)Integer.valueOf(this.statement.getWrapped().executeUpdate(ddlExpr));
            DDLCommandEnlist ddle = new DDLCommandEnlist();
            ddle.enlistDDLCommand(SQLConverter.restoreWorkAroundFunctions(this.sql), ddlType);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return ret;
    }

    private boolean checkDDL() {
        return SQLConverter.checkDDL(this.sql);
    }

    public Object executeBase() throws SQLException {
        Object retv;
        UcanaccessConnection conn = (UcanaccessConnection)this.statement.getConnection();
        UcanaccessConnection.setCtxConnection(conn);
        if (this.commandType.equals((Object)CommandType.BATCH)) {
            UcanaccessConnection.setCtxExecId("BATCH_ID");
        } else {
            UcanaccessConnection.setCtxExecId(String.valueOf(Math.random()));
        }
        if (this.checkDDL()) {
            retv = this.addDDLCommand();
        } else {
            try {
                retv = this.executeWrapped();
            }
            catch (SQLException e) {
                if (conn.getAutoCommit()) {
                    conn.rollback();
                }
                throw e;
            }
        }
        if (conn.getAutoCommit()) {
            conn.commit();
        }
        return retv;
    }

    public abstract Object executeWrapped() throws SQLException;

    ResultSet getWrappedResultSet() {
        return this.resultSet.getWrapped();
    }

    Statement getWrappedStatement() {
        return this.statement.getWrapped();
    }

    void setStatement(UcanaccessStatement statement) {
        this.statement = statement;
    }

    protected static enum CommandType {
        BATCH,
        NO_ARGUMENTS,
        PREPARED_STATEMENT,
        UPDATABLE_RESULTSET,
        WITH_AUTO_GENERATED_KEYS,
        WITH_COLUMNS_NAME,
        WITH_INDEXES;

    }
}

