/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.Execute;
import net.ucanaccess.jdbc.ExecuteUpdate;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.jdbc.UcanaccessStatement;

public class UcanaccessPreparedStatement
extends UcanaccessStatement
implements PreparedStatement {
    private PreparedStatement wrapped;
    private String sql;
    private HashMap<Integer, ParameterReset> memento = new HashMap();

    public UcanaccessPreparedStatement(String sql, PreparedStatement hidden, UcanaccessConnection connection) throws SQLException {
        super(hidden, connection);
        this.sql = sql;
        this.wrapped = hidden;
        if (hidden == null) {
            ((UcanaccessStatement)this).wrapped = connection.createStatement();
        }
    }

    private void addMementoEntry(String methodName, Class<?>[] argClasses, Object ... args) {
        Class[] ac = new Class[args.length];
        ac[0] = Integer.TYPE;
        int y = 1;
        while (y < ac.length) {
            ac[y] = argClasses[y - 1];
            ++y;
        }
        this.memento.put((Integer)args[0], new ParameterReset(methodName, ac, args));
    }

    private void parametersReset() {
        for (ParameterReset pr : this.memento.values()) {
            pr.execute();
        }
    }

    private Reader markableReader(Reader r) throws SQLException {
        return this.markableReader(r, -1L);
    }

    private Reader markableReader(Reader r, long l) throws SQLException {
        if (r.markSupported() && l < 0L) {
            boolean marked = true;
            try {
                r.mark(1000000);
            }
            catch (IOException e) {
                marked = false;
            }
            if (marked) {
                return r;
            }
        }
        StringBuffer sb = new StringBuffer();
        int dim = l >= 0L ? (int)l : 4096;
        char[] cb = new char[dim];
        try {
            int rd;
            while ((rd = r.read(cb)) >= 0) {
                sb.append(Arrays.copyOf(cb, rd));
                if (l >= 0L) break;
            }
            StringReader sr = new StringReader(sb.toString());
            sr.mark(1000000);
            return sr;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private InputStream markableInputStream(InputStream is) throws SQLException {
        return this.markableInputStream(is, -1L);
    }

    private InputStream markableInputStream(InputStream is, long l) throws SQLException {
        if (is.markSupported() && l < 0L) {
            is.mark(1000000);
            return is;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int dim = l >= 0L ? (int)l : 4096;
        byte[] buffer = new byte[dim];
        try {
            int rd;
            while ((rd = is.read(buffer)) >= 0) {
                bos.write(buffer, 0, rd);
                if (l >= 0L) break;
            }
            bos.flush();
            ByteArrayInputStream ir = new ByteArrayInputStream(bos.toByteArray());
            ir.mark(1000000);
            return ir;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void resetReader(Reader r) throws SQLException {
        try {
            r.reset();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void resetInputStream(InputStream is) throws SQLException {
        try {
            is.reset();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void preprocess() throws SQLException {
        if (SQLConverter.hasIdentity(this.sql)) {
            this.sql = SQLConverter.preprocess(this.sql, ((UcanaccessConnection)this.getConnection()).getLastGeneratedKey());
            this.reset();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.wrapped.addBatch();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.memento.clear();
            this.wrapped.clearParameters();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            if (this.wrapped == null) {
                return ((UcanaccessStatement)this).wrapped.execute(this.sql);
            }
            this.preprocess();
            ((UcanaccessConnection)this.getConnection()).setCurrentStatement(this);
            this.checkLastModified();
            return new Execute(this).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            this.preprocess();
            ((UcanaccessConnection)this.getConnection()).setCurrentStatement(this);
            this.checkLastModified();
            return new UcanaccessResultSet(this.wrapped.executeQuery(), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            if (this.wrapped == null) {
                return ((UcanaccessStatement)this).wrapped.executeUpdate(this.sql);
            }
            this.preprocess();
            ((UcanaccessConnection)this.getConnection()).setCurrentStatement(this);
            this.checkLastModified();
            int y = new ExecuteUpdate(this).execute();
            return y;
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.wrapped.getMetaData();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.wrapped.getParameterMetaData();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setArray(int idx, Array array) throws SQLException {
        try {
            this.addMementoEntry("setArray", new Class[]{Array.class}, idx, array);
            this.wrapped.setArray(idx, array);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setAsciiStream(int idx, InputStream is) throws SQLException {
        try {
            is = this.markableInputStream(is);
            this.addMementoEntry("setAsciiStream", new Class[]{InputStream.class}, idx, is);
            this.wrapped.setAsciiStream(idx, is);
            this.resetInputStream(is);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setAsciiStream(int idx, InputStream is, int length) throws SQLException {
        try {
            is = this.markableInputStream(is, length);
            this.addMementoEntry("setAsciiStream", new Class[]{InputStream.class, Integer.TYPE}, idx, is, length);
            this.wrapped.setAsciiStream(idx, is, length);
            this.resetInputStream(is);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setAsciiStream(int idx, InputStream is, long length) throws SQLException {
        try {
            is = this.markableInputStream(is, length);
            this.addMementoEntry("setAsciiStream", new Class[]{InputStream.class, Long.TYPE}, idx, is, length);
            this.wrapped.setAsciiStream(idx, is, length);
            this.resetInputStream(is);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBigDecimal(int idx, BigDecimal dec) throws SQLException {
        try {
            this.addMementoEntry("setBigDecimal", new Class[]{BigDecimal.class}, idx, dec);
            this.wrapped.setBigDecimal(idx, dec);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBinaryStream(int idx, InputStream is) throws SQLException {
        try {
            this.addMementoEntry("setBinaryStream", new Class[]{InputStream.class}, idx, is);
            this.wrapped.setBinaryStream(idx, is);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBinaryStream(int idx, InputStream is, int length) throws SQLException {
        try {
            this.addMementoEntry("setBinaryStream", new Class[]{InputStream.class, Integer.TYPE}, idx, is, length);
            this.wrapped.setBinaryStream(idx, is, length);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBinaryStream(int idx, InputStream is, long length) throws SQLException {
        try {
            this.addMementoEntry("setBinaryStream", new Class[]{InputStream.class, Long.TYPE}, idx, is, length);
            this.wrapped.setBinaryStream(idx, is, length);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBlob(int idx, Blob blob) throws SQLException {
        try {
            this.addMementoEntry("setBlob", new Class[]{Blob.class}, idx, blob);
            this.wrapped.setBlob(idx, blob);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBlob(int idx, InputStream is) throws SQLException {
        try {
            this.addMementoEntry("setBlob", new Class[]{InputStream.class}, idx, is);
            this.wrapped.setBlob(idx, is);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBlob(int idx, InputStream is, long length) throws SQLException {
        try {
            this.addMementoEntry("setBlob", new Class[]{InputStream.class, Long.TYPE}, idx, is, length);
            this.wrapped.setBlob(idx, is, length);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBoolean(int idx, boolean bool) throws SQLException {
        try {
            this.addMementoEntry("setBoolean", new Class[]{Boolean.TYPE}, idx, bool);
            this.wrapped.setBoolean(idx, bool);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setByte(int idx, byte b) throws SQLException {
        try {
            this.addMementoEntry("setByte", new Class[]{Byte.TYPE}, idx, b);
            this.wrapped.setByte(idx, b);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setBytes(int idx, byte[] bytes) throws SQLException {
        try {
            this.addMementoEntry("setBytes", new Class[]{byte[].class}, idx, bytes);
            this.wrapped.setBytes(idx, bytes);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setCharacterStream(int idx, Reader reader) throws SQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setCharacterStream", new Class[]{Reader.class}, idx, reader);
            this.wrapped.setCharacterStream(idx, reader);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setCharacterStream(int idx, Reader reader, int length) throws SQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setCharacterStream", new Class[]{Reader.class, Integer.TYPE}, idx, reader, length);
            this.wrapped.setCharacterStream(idx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setCharacterStream(int idx, Reader reader, long length) throws SQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setCharacterStream", new Class[]{Reader.class, Long.TYPE}, idx, reader, length);
            this.wrapped.setCharacterStream(idx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setClob(int idx, Clob clob) throws SQLException {
        try {
            this.addMementoEntry("setClob", new Class[]{Clob.class}, idx, clob);
            this.wrapped.setClob(idx, clob);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setClob(int idx, Reader reader) throws SQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setClob", new Class[]{Reader.class}, idx, reader);
            this.wrapped.setClob(idx, reader);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setClob(int idx, Reader reader, long length) throws SQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setClob", new Class[]{Reader.class, Long.TYPE}, idx, reader, length);
            this.wrapped.setClob(idx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.wrapped.setCursorName(name);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setDate(int idx, Date date) throws SQLException {
        try {
            this.addMementoEntry("setDate", new Class[]{Date.class}, idx, date);
            this.wrapped.setDate(idx, date);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setDate(int idx, Date date, Calendar cal) throws SQLException {
        try {
            this.addMementoEntry("setDate", new Class[]{Date.class, Calendar.class}, idx, date, cal);
            this.wrapped.setDate(idx, date, cal);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setDouble(int idx, double d) throws SQLException {
        try {
            this.addMementoEntry("setDouble", new Class[]{Double.TYPE}, idx, d);
            this.wrapped.setDouble(idx, d);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setFloat(int idx, float f) throws SQLException {
        try {
            this.addMementoEntry("setFloat", new Class[]{Float.TYPE}, idx, Float.valueOf(f));
            this.wrapped.setFloat(idx, f);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setInt(int idx, int i) throws SQLException {
        try {
            this.addMementoEntry("setInt", new Class[]{Integer.TYPE}, idx, i);
            this.wrapped.setInt(idx, i);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setLong(int idx, long l) throws SQLException {
        try {
            this.addMementoEntry("setLong", new Class[]{Long.TYPE}, idx, l);
            this.wrapped.setLong(idx, l);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNCharacterStream(int idx, Reader reader) throws SQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setNCharacterStream", new Class[]{Reader.class}, idx, reader);
            this.wrapped.setNCharacterStream(idx, reader);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNCharacterStream(int idx, Reader reader, long l) throws SQLException {
        try {
            reader = this.markableReader(reader, l);
            this.addMementoEntry("setNCharacterStream", new Class[]{Reader.class, Long.TYPE}, idx, reader, l);
            this.wrapped.setNCharacterStream(idx, reader, l);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNClob(int idx, NClob nclob) throws SQLException {
        try {
            this.addMementoEntry("setNClob", new Class[]{NClob.class}, idx, nclob);
            this.wrapped.setNClob(idx, nclob);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNClob(int idx, Reader reader) throws SQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setNClob", new Class[]{Reader.class}, idx, reader);
            this.wrapped.setNClob(idx, reader);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNClob(int idx, Reader reader, long length) throws SQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setNClob", new Class[]{Reader.class, Long.TYPE}, idx, reader, length);
            this.wrapped.setNClob(idx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNString(int idx, String string) throws SQLException {
        try {
            this.addMementoEntry("setNString", new Class[]{String.class}, idx, string);
            this.wrapped.setNString(idx, string);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNull(int idx, int sqlt) throws SQLException {
        try {
            this.addMementoEntry("setNull", new Class[]{Integer.TYPE}, idx, sqlt);
            this.wrapped.setNull(idx, sqlt);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setNull(int idx, int sqlt, String tn) throws SQLException {
        try {
            this.addMementoEntry("setNull", new Class[]{Integer.TYPE, String.class}, idx, sqlt, tn);
            this.wrapped.setNull(idx, sqlt, tn);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setObject(int idx, Object x) throws SQLException {
        try {
            this.addMementoEntry("setObject", new Class[]{Object.class}, idx, x);
            this.wrapped.setObject(idx, x);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setObject(int idx, Object x, int tsqlt) throws SQLException {
        try {
            this.addMementoEntry("setObject", new Class[]{Object.class, Integer.TYPE}, idx, x, tsqlt);
            this.wrapped.setObject(idx, x, tsqlt);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setObject(int idx, Object x, int tsqlt, int sol) throws SQLException {
        try {
            this.addMementoEntry("setObject", new Class[]{Object.class, Integer.TYPE, Integer.TYPE}, idx, x, tsqlt, sol);
            this.wrapped.setObject(idx, x, tsqlt, sol);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setRef(int idx, Ref ref) throws SQLException {
        try {
            this.addMementoEntry("setRef", new Class[]{Ref.class}, idx, ref);
            this.wrapped.setRef(idx, ref);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setRowId(int idx, RowId rowId) throws SQLException {
        try {
            this.addMementoEntry("setRowId", new Class[]{RowId.class}, idx, rowId);
            this.wrapped.setRowId(idx, rowId);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setShort(int idx, short sht) throws SQLException {
        try {
            this.addMementoEntry("setShort", new Class[]{Short.TYPE}, idx, sht);
            this.wrapped.setShort(idx, sht);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setSQLXML(int idx, SQLXML sx) throws SQLException {
        try {
            this.addMementoEntry("setSQLXML", new Class[]{SQLXML.class}, idx, sx);
            this.wrapped.setSQLXML(idx, sx);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setString(int idx, String string) throws SQLException {
        try {
            this.addMementoEntry("setString", new Class[]{String.class}, idx, string);
            this.wrapped.setString(idx, string);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setTime(int idx, Time time) throws SQLException {
        try {
            Calendar cl = Calendar.getInstance();
            cl.setTime(time);
            cl.set(1899, 11, 30);
            cl.set(14, 0);
            Timestamp ts = new Timestamp(cl.getTimeInMillis());
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class}, idx, ts);
            this.wrapped.setTimestamp(idx, ts);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setTime(int idx, Time time, Calendar cal) throws SQLException {
        try {
            Calendar cl = Calendar.getInstance();
            cal.setTime(time);
            cl.set(1899, 11, 30, cal.get(11), cal.get(12), cal.get(13));
            cl.set(14, 0);
            Timestamp ts = new Timestamp(cl.getTimeInMillis());
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class}, idx, ts);
            this.wrapped.setTimestamp(idx, ts);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setTimestamp(int idx, Timestamp ts) throws SQLException {
        try {
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class}, idx, ts);
            this.wrapped.setTimestamp(idx, ts);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setTimestamp(int idx, Timestamp ts, Calendar cal) throws SQLException {
        try {
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class, Calendar.class}, idx, ts, cal);
            this.wrapped.setTimestamp(idx, ts, cal);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int idx, InputStream is, int length) throws SQLException {
        try {
            is = this.markableInputStream(is, length);
            this.addMementoEntry("setUnicodeStream", new Class[]{InputStream.class, Integer.TYPE}, idx, is, length);
            this.wrapped.setUnicodeStream(idx, is, length);
            this.resetInputStream(is);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setURL(int idx, URL url) throws SQLException {
        try {
            String arg = "#" + url.toString() + "#";
            this.addMementoEntry("setString", new Class[]{String.class}, idx, arg);
            this.wrapped.setString(idx, arg);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.wrapped.unwrap(iface);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    protected void reset() throws SQLException {
        if (this.wrapped == null) {
            return;
        }
        PreparedStatement old = this.wrapped;
        this.wrapped = ((UcanaccessConnection)this.getConnection()).getHSQLDBConnection().prepareStatement(this.sql, this.wrapped.getResultSetType(), this.wrapped.getResultSetConcurrency(), this.wrapped.getResultSetHoldability());
        this.reset(this.wrapped);
        this.parametersReset();
        old.close();
    }

    private class ParameterReset {
        private String methodName;
        private Object[] args;
        private Class<?>[] argClasses;

        private ParameterReset(String methodName, Class<?>[] argClasses, Object ... args) {
            this.methodName = methodName;
            this.args = args;
            this.argClasses = argClasses;
        }

        private void execute() {
            try {
                Method mth = PreparedStatement.class.getDeclaredMethod(this.methodName, this.argClasses);
                mth.invoke((Object)UcanaccessPreparedStatement.this.wrapped, this.args);
                if (this.args[1] instanceof StringReader) {
                    StringReader sr = (StringReader)this.args[1];
                    sr.reset();
                }
                if (this.args[1] instanceof InputStream && ("setAsciiStream".equals(this.methodName) || "setUnicodeStream".equals(this.methodName))) {
                    ((InputStream)this.args[1]).reset();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

