/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.SQLException;
import net.ucanaccess.util.Logger;

public class UcanaccessSQLException
extends SQLException {
    private static final long serialVersionUID = -1432048647665807662L;
    private Throwable cause;
    private int errorCode;
    private String sqlState;

    public UcanaccessSQLException() {
    }

    public UcanaccessSQLException(ExceptionMessages reason) {
        super(Logger.getMessage(reason.name()));
        this.sqlState = String.valueOf(15000);
        this.errorCode = 15000;
    }

    public UcanaccessSQLException(String reason, String SQLState) {
        super(Logger.getMessage(reason), SQLState);
    }

    public UcanaccessSQLException(String reason, String SQLState, int vendorCode) {
        super(Logger.getMessage(reason), SQLState, vendorCode);
    }

    public UcanaccessSQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(Logger.getMessage(reason), sqlState, vendorCode, cause);
    }

    public UcanaccessSQLException(String reason, String sqlState, Throwable cause) {
        super(Logger.getMessage(reason), sqlState, cause);
    }

    public UcanaccessSQLException(String reason, Throwable cause) {
        super(Logger.getMessage(reason), cause);
    }

    public UcanaccessSQLException(Throwable cause) {
        super(UcanaccessSQLException.explaneCause(cause));
        this.cause = cause;
        if (cause instanceof SQLException) {
            SQLException se = (SQLException)cause;
            this.errorCode = se.getErrorCode();
            this.sqlState = se.getSQLState();
        } else {
            this.sqlState = String.valueOf(15000);
            this.errorCode = 15000;
        }
    }

    public static String explaneCause(Throwable cause) {
        SQLException se;
        if (cause instanceof SQLException && (se = (SQLException)cause).getErrorCode() == -5562) {
            return String.valueOf(cause.getMessage()) + " " + Logger.getMessage(ExceptionMessages.INVALID_TYPES_IN_COMBINATION.name());
        }
        return cause.getMessage();
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode == 0 ? super.getErrorCode() : this.errorCode;
    }

    @Override
    public String getSQLState() {
        return this.sqlState == null ? super.getSQLState() : this.sqlState;
    }

    public static enum ExceptionMessages {
        CONCURRENT_PROCESS_ACCESS,
        INVALID_CREATE_STATEMENT,
        INVALID_INTERVAL_VALUE,
        INVALID_JACKCESS_OPENER,
        INVALID_MONTH_NUMBER,
        NOT_A_VALID_PASSWORD,
        ONLY_IN_MEMORY_ALLOWED,
        UNPARSABLE_DATE,
        COMPLEX_TYPE_UNSUPPORTED,
        INVALID_PARAMETER,
        INVALID_TYPES_IN_COMBINATION,
        UNSUPPORTED_TYPE,
        STATEMENT_DDL,
        CLOSE_ON_COMPLETION_STATEMENT,
        ACCESS_97;

    }
}

