/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.Execute;
import net.ucanaccess.jdbc.ExecuteUpdate;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCStatement;

public class UcanaccessStatement
implements Statement {
    private UcanaccessConnection connection;
    protected Statement wrapped;
    private int generatedKey = -10000;

    public UcanaccessStatement(Statement wrapped, UcanaccessConnection conn) throws SQLException {
        this.wrapped = wrapped;
        this.connection = conn;
    }

    private String convertSQL(String sql, UcanaccessConnection conn) {
        if (SQLConverter.checkDDL(sql)) {
            return sql;
        }
        return this.preprocess(SQLConverter.convertSQL(sql, conn));
    }

    private String convertSQL(String sql) {
        if (SQLConverter.checkDDL(sql)) {
            return sql;
        }
        return this.preprocess(SQLConverter.convertSQL(sql));
    }

    private String preprocess(String sql) {
        return this.connection.preprocess(sql);
    }

    @Override
    public void addBatch(String batch) throws SQLException {
        try {
            this.wrapped.addBatch(SQLConverter.convertSQL(batch));
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.wrapped.cancel();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.wrapped.clearBatch();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.wrapped.clearWarnings();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.wrapped.close();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        block4: {
            try {
                if (this.wrapped instanceof JDBCStatement) {
                    ((JDBCStatement)this.wrapped).closeOnCompletion();
                    break block4;
                }
                if (this.wrapped instanceof JDBCPreparedStatement) {
                    ((JDBCPreparedStatement)this.wrapped).closeOnCompletion();
                    break block4;
                }
                throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.CLOSE_ON_COMPLETION_STATEMENT);
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
    }

    protected void checkLastModified() throws SQLException {
        if (this.connection.getAutoCommit() || this.connection.isCheckModified()) {
            Connection hsqldb = this.wrapped.getConnection();
            this.connection.checkLastModified();
            if (hsqldb != this.connection.getHSQLDBConnection()) {
                this.reset();
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql, this.connection);
            return new Execute(this, sql).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql, this.connection);
            return new Execute(this, sql, autoGeneratedKeys).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean execute(String sql, int[] indexes) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql, this.connection);
            return new Execute(this, sql, indexes).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql, this.connection);
            return new Execute(this, sql, columnNames).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            return new ExecuteUpdate(this).executeBatch();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql, this.connection);
            return new UcanaccessResultSet(this.wrapped.executeQuery(sql), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql);
            return new ExecuteUpdate(this, sql).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int executeUpdate(String sql, int arg) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql);
            return new ExecuteUpdate(this, sql, arg).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] arg) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql);
            return new ExecuteUpdate(this, sql, arg).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] arg) throws SQLException {
        try {
            this.connection.setCurrentStatement(this);
            this.checkLastModified();
            sql = this.convertSQL(sql);
            return new ExecuteUpdate(this, sql, arg).execute();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.wrapped.getFetchDirection();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.wrapped.getFetchSize();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            this.checkLastModified();
            Connection conn = this.connection.getHSQLDBConnection();
            Statement st = conn.createStatement();
            StringBuffer sql = new StringBuffer();
            if (this.generatedKey != -10000) {
                sql.append(" SELECT ").append(this.generatedKey).append(" AS GENERATED_KEY ").append(" FROM DUAL");
            } else {
                sql.append(" SELECT ").append(0).append(" AS GENERATED_KEY ").append(" FROM DUAL where 1=2 ");
            }
            return new UcanaccessResultSet(st.executeQuery(sql.toString()), this);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.wrapped.getMaxFieldSize();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.wrapped.getMaxRows();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.wrapped.getMoreResults();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        try {
            return this.wrapped.getMoreResults(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.wrapped.getQueryTimeout();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet rs;
        block3: {
            try {
                rs = this.wrapped.getResultSet();
                if (this.wrapped != null && rs != null) break block3;
                return null;
            }
            catch (SQLException e) {
                throw new UcanaccessSQLException(e);
            }
        }
        return new UcanaccessResultSet(rs, this);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.wrapped.getResultSetConcurrency();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.wrapped.getResultSetHoldability();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.wrapped.getResultSetType();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.wrapped.getUpdateCount();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.wrapped.getWarnings();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    Statement getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.wrapped.isClosed();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return ((JDBCStatement)this.wrapped).isCloseOnCompletion();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.wrapped.isPoolable();
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        try {
            return this.wrapped.isWrapperFor(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        try {
            this.wrapped.setCursorName(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        try {
            this.wrapped.setEscapeProcessing(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        try {
            this.wrapped.setFetchDirection(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        try {
            this.wrapped.setFetchSize(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        try {
            this.wrapped.setMaxFieldSize(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        try {
            this.wrapped.setMaxRows(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        try {
            this.wrapped.setPoolable(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        try {
            this.wrapped.setQueryTimeout(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        try {
            return this.wrapped.unwrap(arg0);
        }
        catch (SQLException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    protected void reset() throws SQLException {
        Statement old = this.wrapped;
        this.reset(((UcanaccessConnection)this.getConnection()).getHSQLDBConnection().createStatement(this.wrapped.getResultSetType(), this.wrapped.getResultSetConcurrency(), this.wrapped.getResultSetHoldability()));
        old.close();
    }

    protected void reset(Statement st) throws SQLException {
        int maxr = this.wrapped.getMaxRows();
        int maxf = this.wrapped.getMaxFieldSize();
        int direction = this.wrapped.getFetchDirection();
        int fs = this.wrapped.getFetchSize();
        int qt = this.wrapped.getQueryTimeout();
        this.wrapped = st;
        this.wrapped.setMaxRows(maxr);
        this.wrapped.setMaxFieldSize(maxf);
        this.wrapped.setFetchDirection(direction);
        this.wrapped.setFetchSize(fs);
        this.wrapped.setQueryTimeout(qt);
    }

    public void setGeneratedKey(int key) {
        this.generatedKey = key;
    }
}

