/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.triggers;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import java.sql.SQLException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.triggers.AutoNumberManager;
import net.ucanaccess.triggers.TriggerBase;
import net.ucanaccess.triggers.TriggerException;
import net.ucanaccess.util.Logger;

public class TriggerAutoNumber
extends TriggerBase {
    public static int autorandom = -1;
    private static final String GUID_PATTERN = "\\s*[{]?([\\p{XDigit}]{8})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{4})-([\\p{XDigit}]{12})[}]?\\s*";

    public void fire(int type, String name, String tableName, Object[] oldR, Object[] newR) {
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        if (conn.isFeedbackState()) {
            return;
        }
        try {
            Table t = this.getTable(tableName, conn);
            if (t == null) {
                throw new RuntimeException(String.valueOf(Logger.getMessage("TABLE_DOESNT_EXIST")) + " :" + tableName);
            }
            int i = 0;
            for (Column cli : t.getColumns()) {
                ColumnImpl cl = (ColumnImpl)cli;
                if (cl.isAutoNumber()) {
                    if (type == 6) {
                        if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.GUID)) {
                            newR[i] = cl.getAutoNumberGenerator().getNext(cl.getAutoNumberGenerator().getLast());
                        } else if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG)) {
                            int keyg = AutoNumberManager.getNext((Column)cl);
                            newR[i] = keyg;
                            conn.setGeneratedKey(keyg);
                        }
                    } else if (type == 8 && cl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG)) {
                        if (!oldR[i].equals(newR[i])) {
                            throw new RuntimeException("Cannot update autoincrement column");
                        }
                    } else if (cl.getAutoNumberGenerator().getType().equals((Object)DataType.GUID)) {
                        this.validateGUID(newR[i]);
                    }
                } else if (DataType.BOOLEAN.equals((Object)cl.getType()) && newR[i] == null) {
                    newR[i] = false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new TriggerException(e.getMessage());
        }
    }

    private void validateGUID(Object guid) throws SQLException {
        String guidS;
        if (guid != null && guid instanceof String && ((guidS = (String)guid).length() != 38 || !guidS.matches(GUID_PATTERN))) {
            throw new SQLException("Invalid guid format " + guidS);
        }
    }
}

