CREATE TABLE Order_Fact
(
  Customer_ID INT NOT NULL,
  Employee_ID INT NOT NULL,
  Street_ID INT NOT NULL,
  Product_ID INT NOT NULL,
  Order_Date DATE NOT NULL,
  Order_ID INT NOT NULL,
  Order_Type SMALLINT,
  Delivery_Date DATE,
  Quantity SMALLINT,
  Total_Retail_Price DECIMAL(13,2),
  Costprice_Per_Unit DECIMAL(13,2),
  Discount DECIMAL(5,2),
  PRIMARY KEY (Customer_ID, Employee_ID, Street_ID, Product_ID, Order_Date, Order_ID),
  FOREIGN KEY (Customer_ID) REFERENCES Customer_Dim (Customer_ID),
  FOREIGN KEY (Employee_ID) REFERENCES Organization_Dim (Employee_ID),
  FOREIGN KEY (Street_ID) REFERENCES Geography_Dim (Street_ID),
  FOREIGN KEY (Product_ID) REFERENCES Product_Dim (Product_ID)
);

CREATE TABLE Geography_Dim
(
  Street_ID INT PRIMARY KEY NOT NULL,
  Continent VARCHAR(30),
  Country CHARACTER(2),
  State_Code CHARACTER(2),
  State VARCHAR(25),
  Region  VARCHAR(30),
  Province  VARCHAR(30),
  County  VARCHAR(60),
  City  VARCHAR(30),
  Postal_Code  CHARACTER(10),
  Street_Name  VARCHAR(45)
);

CREATE TABLE Product_Dim
(
  Product_ID INT PRIMARY KEY NOT NULL,
  Product_Line CHARACTER(20),
  Product_Category CHARACTER(25),
  Product_Group CHARACTER(25),
  Product_Name CHARACTER(45),
  Supplier_Country CHARACTER(2),
  Supplier_Name CHARACTER(30),  
  Supplier_ID INT  
);
 
CREATE TABLE Time_Dim
(
  Date_ID DATE PRIMARY KEY NOT NULL,
  Year_ID CHARACTER(4),
  Quarter CHARACTER(6),
  Month_Name VARCHAR(20),
  Weekday_Name VARCHAR(20),
  Month_Num SMALLINT,
  Weekday_Num SMALLINT
);

CREATE TABLE Customer_Dim
(
  Customer_ID INT PRIMARY KEY NOT NULL,
  Customer_Country CHARACTER(2),
  Customer_Group CHARACTER(40),
  Customer_Type CHARACTER(40),
  Customer_Gender CHARACTER(1),
  Customer_Age_Group CHARACTER(12),
  Customer_Age SMALLINT,
  Customer_Name CHARACTER(40),
  Customer_Firstname CHARACTER(20),
  Customer_Lastname CHARACTER(30),
  Customer_Birth_Date DATE
);

CREATE TABLE Organization_Dim
(
  Employee_ID INT PRIMARY KEY NOT NULL,
  Employee_Country CHARACTER(2),
  Company CHARACTER(30),
  Departement VARCHAR(40),
  Section VARCHAR(40),
  Org_Group VARCHAR(40),
  Job_Title VARCHAR(25),
  Employee_Name VARCHAR(40),
  Employee_Gender CHARACTER(1),
  Salary DECIMAL(13),
  Employee_Birth_Date DATE,
  Employee_Hire_Date DATE,
  Employee_Term_Date DATE
);