#On importe les librairies qui vont nous aider à traiter les données
import json
import sys

#-------------Definition des fonctions-------------------------------------------------------------------------------------------

def loadJsonData(nomFichierJson):
    """
    Cette fonction a comme parametre le nom du fichier Json qui est a ouvrir.
    Une fois le fichier Json ouvert en lecture 'rt', on charge toutes les donnees dans 'donneesJson'
    Ensuite, on ferme le fichier Json ouvert pour liberer les ressources de la machine
    Si jamais le fichier est introuvable (nom incorrect), alors on affiche un message d'erreur et on quitte le programme
    Puis enfin, on retourne la liste qui contient toutes les donnees du fichier Json
    """
    try:
        fichierJson = open(nomFichierJson+".json", "rt", encoding = 'utf-8')
        donneesJson = json.load(fichierJson)
        fichierJson.close()
    except FileNotFoundError:
        #Si le fichier n'est pas trouvé, on affiche un message d'erreur et on arrête le programme
        print("Le fichier '" + nomFichierJson + ".json' n'a pas été trouvé.")
        print("Veuillez réessayer.")
        sys.exit()
        
    return donneesJson

#-------------Programme Principal-------------------------------------------------------------------------------------------

#On demande le nom du fichier Json à traiter
nomFichierJson = input("Quel est le nom de votre fichier Json ? (Nom sans l'extension .json)")
#On initialise une liste avec les donnees du fichier json. On charge la liste a l'aide de la fonction chargementDonneesJson()
listeDonneesJson = loadJsonData(nomFichierJson)
    
#On demande à l'utilisateur le nom qu'aura le fichier CSV puis on demande également le séparateur que l'utilisateur veut utiliser
nomFichierCsv = input("Comment voulez-vous nommez votre fichier CSV ? (Nom sans l'extension .csv)")
separateur = input("Quel séparateur voulez-vous utilisez ?")
#On ouvre le fichier en ecriture pour pouvoir ecrire des donnees dessus
fichierCsv = open(nomFichierCsv+".csv", "w", encoding = 'utf-8')

#On initialise une liste qui contient les entetes qui seront dans le fichier CSV
listeEntete = ["ID", "URL", "Titre", "Chapeau", "Categorie", "Mots cles", "Date de debut", "Heure de debut", "Date de fin", "Heure de fin", "Nom du lieu", "Adresse du lieu", "Code Postal", "Ville", "Coordonnees geographiques", "Acces PMR", "Acces mal voyant", "Acces mal entendant", "Transport", "Nom de contact", "Telephone de contact", "Email de contact", "Url de contact", "Url Facebook", "Url Twitter", "Type d'acces", "Url de reservation", "Telephone de reservation", "Email de reservation", "Detail du prix", "Url de l'image de couverture"]
#A chaque fois qu'une entete est trouvee, on l'ecrit dans le fichier csv ouvert en ecriture, avec le separateur
for uneEntete in listeEntete:
    fichierCsv.write('"'+uneEntete+'"')
    fichierCsv.write(separateur)
#On revient à la ligne une fois que les entetes ont etes mises dans le fichier CSV
fichierCsv.write("\n")

#On initialise la liste qui contiendra les listes de donnees
listeDonnees = []
#On initialise la variable qui compteras le nombre de donnees manquantes et qui n'ont pas pu etres traitees
nbDonneesManquantes = 0

#Pour chaque element dans la liste avec les donnees du fichier json, on ajoute chaque donnee dans la liste finale 'listeDonnees' avec un separateur
for unElement in listeDonneesJson:
    try:
        listeDonnees.append('"'+unElement['fields']['id']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['url']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['title']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['lead_text']+'"'+separateur)
        
        #Le champ description a ete enleve car il y a trop de caractères a verifier et a remplacer
        #La boucle ci-dessous verifie chaque caractere de la description et enleve ceux qui peuvent alterer le fichier csv (; ou ")
        #La boucle marche mais le temps d'execution est beaucoup trop long. Il est plus judicieux de supprimer le champ description
        # for unCaractere in unElement['fields']['description'] :
        #     if unCaractere != ";":
        #         descriptionListe.append(unCaractere)
        #     else:
        #         descriptionListe.append("-")
                
        # description = descriptionListe
        # listeDonnees.append('"'+str(description)+'"'+separateur)
        
        listeDonnees.append('"'+unElement['fields']['category']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['tags']+'"'+separateur)
        
        #On separe la date et l'heure de debut et on les ajoutes separemment dans la liste de donnees
        
        dateHeureDebutBrut = unElement['fields']['date_start']
        listeDateHeureDebut = dateHeureDebutBrut.split("T")
        dateDebut = listeDateHeureDebut[0]
        #On enleve les infos superflus de l'heure (9 derniers caracteres)
        heureDebut = listeDateHeureDebut[1][:-9]
        listeDonnees.append('"'+dateDebut+'"'+separateur)
        listeDonnees.append('"'+heureDebut+'"'+separateur)
        
        #On separe la date et l'heure de fin et on les ajoutes separemment dans la liste de donnees
        
        dateHeureFinBrut = unElement['fields']['date_end']
        listeDateHeureFin = dateHeureFinBrut.split("T")
        dateFin = listeDateHeureFin[0]
        #On enleve les infos superflus de l'heure (9 derniers caracteres)
        heureFin = listeDateHeureFin[1][:-9]
        listeDonnees.append('"'+dateFin+'"'+separateur)
        listeDonnees.append('"'+heureFin+'"'+separateur)
        
        listeDonnees.append('"'+unElement['fields']['address_name']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['address_street']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['address_zipcode']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['address_city']+'"'+separateur)
        listeDonnees.append('"'+str(unElement['fields']['lat_lon'])+'"'+separateur)
        listeDonnees.append('"'+str(+unElement['fields']['pmr'])+'"'+separateur)
        listeDonnees.append('"'+str(+unElement['fields']['blind'])+'"'+separateur)
        listeDonnees.append('"'+str(+unElement['fields']['deaf'])+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['transport']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['contact_name']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['contact_phone']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['contact_mail']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['contact_url']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['contact_facebook']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['contact_twitter']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['access_type']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['access_link']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['access_phone']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['access_mail']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['price_detail']+'"'+separateur)
        listeDonnees.append('"'+unElement['fields']['cover_url']+'"'+separateur)
    except KeyError:
        #Si une des donnees n'est pas trouvee, alors on affiche une valeur vide
        listeDonnees.append(";;")
        #Si une donnee est nulle alors on ajoute une donnee manquante au compteur
        nbDonneesManquantes += 1
        
    #On revient à la ligne quand une ligne de donnees est complete
    listeDonnees.append("\n")
    
#Pour chaque liste de donnees dans la liste 'listeDonnees', on l'ecrit dans le fichier de sortie CSV (1 liste = 1 ligne de donnees dans le fichier csv)
for uneDonnee in listeDonnees:
    fichierCsv.write(str(uneDonnee))
    
#Apres avoir fini d'ecrire sur le fichier csv de sortie, on le ferme pour liberer la memoire de la machine
fichierCsv.close()

#On affiche un message final pour avertir l'utilisateur du programme que la conversion s'est deroule avec succes. On indique egalement le nombre de donnees manquantes.
print("Le fichier " + nomFichierJson + ".json a bien été converti au format CSV. Il y a un total de " + str(nbDonneesManquantes) + " données qui n'ont pas étés trouvées dans votre fichier CSV.")