##############################
#Avant tout, veuillez dfinir votre rprtoire de travail o sont stocks vos fichiers csv
#Session -> Set Working Directory -> Choose Directory...
##############################
#======================IMPORTATION DES DONNEES ET RENOMMAGE DES COLONNES======================
deng <- read.csv("Deng_Train_Labels.csv")
names(deng) <- c("ville", "annee", "semaine", "cas_total")

deng_features <- read.csv("Deng_Train_Features.csv")

test_features <- read.csv("Deng_Test_Features.csv")
names(test_features)[10] <- "air_temperature"

#On enlve la semaine 52 qui n'existe pas dans le dataframe 'deng2005' 
#(La semaine 52 est corrompue en semaine 53 sur l'anne 2005)
test_features <- test_features[!(test_features$weekofyear=="52"),]

#==================================ON COMMENCE LA PREDICTION==================================
#On rtrcie la temprature sur l'anne 2005
deng2005 <- data.frame("annee" = deng[deng$annee=="2005","annee"], 
                       "semaine" = deng[deng$annee=="2005","semaine"], 
                       "cas_total" = deng[deng$annee=="2005","cas_total"],
                       "air_temperature" = deng_features[deng_features$year=="2005","reanalysis_air_temp_k"])

#On enelve les valeurs manquantes du dataframe 'deng2005'
deng2005 <- na.exclude(deng2005)

#On a choisit le modle linaire et maintenant, on le cre
model <- lm(cas_total ~ air_temperature, data = deng2005)

#On cre le dataframe final avec les prdictions de deng de 2007 qui sera export dans un fichier csv
dengPredictionFinal <- data.frame("city" = "sj",
                                  "year" = "2007",
                                  "weekofyear" = test_features[,"weekofyear"],
                                  "total_cases" = round(predict(model, newdata = test_features),2))

#On exporte les prdicitions du dataframe 'dengPredictionFinal'
write.csv2(dengPredictionFinal, file = "Deng_Test_Labels.csv", row.names=FALSE, fileEncoding="latin1")

#On supprime les objets qui ne sont plus utiliss pour librer la mmoire
rm(deng)
rm(deng_features)
rm(deng2005)
rm(model)
rm(test_features)
rm(dengPredictionFinal)