##############################
#Avant tout, veuillez dfinir votre rprtoire de travail o sont stocks vos fichiers csv
#Session -> Set Working Directory -> Choose Directory...
##############################
#Importation des donnes
deng <- read.csv("Deng_Train_Labels.csv")
names(deng) <- c("ville", "annee", "semaine", "cas_total")

deng_features <- read.csv("Deng_Train_Features.csv")

#=====================================================================
#On cre le dataframe de la temprature de l'air (variable tudie), sur toute la priode (1991 -> 2006)
dengAirTemp <- data.frame(deng$annee, deng$semaine, deng$cas_total, round(deng_features$reanalysis_air_temp_k-273.15,2))
names(dengAirTemp) <- c("annee","semaine","cas_total","air_temperature")

#Nuage de points des cas de Deng de 1991  2006
plot(dengAirTemp$cas_total~dengAirTemp$air_temperature, xlab="Temperature de l'air", ylab="Nombres de cas de Deng", main="Cas de deng sur de 1991  2006")

#On rtrcie la temprature sur l'anne 2005
deng2005 <- data.frame("annee" = dengAirTemp[dengAirTemp$annee=="2005","annee"], 
                       "semaine" = dengAirTemp[dengAirTemp$annee=="2005","semaine"], 
                       "cas_total" = dengAirTemp[dengAirTemp$annee=="2005","cas_total"],
                       "air_temperature" = dengAirTemp[dengAirTemp$annee=="2005","air_temperature"])

deng2005 <- na.exclude(deng2005)

#Graphiques avec toutes les tempratures (23  29C)
par(mfrow=c(1,1))
plot(deng2005$cas_total ~ deng2005$air_temperature, xlab="Temperature de l'air", ylab="Nombres de cas de Deng", main="Cas de Deng en fonction de la temprature de l'air en 2005")
#Coefficient de dtermination
model <- lm(deng2005$cas_total ~ deng2005$air_temperature, data = deng2005)
summary(model)$r.squared
abline(model, col="red")

#Nuage de points pour les tempratures < 26C
par(mfrow=c(1,2))
plot(deng2005[deng2005$air_temperature<26,"cas_total"] ~ deng2005[deng2005$air_temperature<26,"air_temperature"], xlab="Temperature de l'air (C)", ylab="Nombres de cas de Deng", main="Temprature < 26C", ylim=c(0,140))
#Coefficient de dtermination
model <- lm(deng2005[deng2005$air_temperature<26,"cas_total"] ~ deng2005[deng2005$air_temperature<26,"air_temperature"], data = deng2005)
summary(model)$r.squared
abline(model, col="red")

#Nuage de points pour les tempratures > 26C
plot(deng2005[deng2005$air_temperature>26,"cas_total"] ~ deng2005[deng2005$air_temperature>26,"air_temperature"], xlab="Temperature de l'air (C)", ylab="Nombres de cas de Deng", main="Temprature > 26C")
#Coefficient de dtermination
model <- lm(deng2005[deng2005$air_temperature>26,"cas_total"] ~ deng2005[deng2005$air_temperature>26,"air_temperature"], data = deng2005)
summary(model)$r.squared
abline(model, col="red")

#===================ON COMMENCE LA PREDICTION ET LES COMPARAISONS===================
#On charge le fichier test_features.csv et on convertie les Kelvin en C
test_features <- read.csv("Deng_Test_Features.csv")
names(test_features)[10] <- "air_temperature"
test_features$air_temperature <- round(test_features$air_temperature-273.15,2)

#Comme la semaine 52 de l'anne 2005 n'existe pas, on la supprime
test_features <- test_features[!(test_features$weekofyear=="52"),]

#Prdiction des cas de deng pour 2007
model <- lm(cas_total ~ air_temperature, data = deng2005)
deng2005$cas_prediction_2007 <- round(predict(model, newdata = test_features),2)

#Dataframe avec les prdictions de deng pour les tempratures suprieure  26 C
dengPredSup26 <- data.frame("annee" = deng2005[deng2005$cas_prediction_2007>26,"annee"], 
                            "semaine" = deng2005[deng2005$cas_prediction_2007>26,"semaine"], 
                            "air_temperature" = deng2005[deng2005$cas_prediction_2007>26,"air_temperature"],
                            "cas_total" = deng2005[deng2005$cas_prediction_2007>26,"cas_total"],
                            "cas_prediction_2007" = deng2005[deng2005$cas_prediction_2007>26,"cas_prediction_2007"])

#Dataframe avec les prdictions de deng pour les tempratures infrieure  26 C
dengPredInf26 <- data.frame("annee" = deng2005[deng2005$cas_prediction_2007<26,"annee"], 
                            "semaine" = deng2005[deng2005$cas_prediction_2007<26,"semaine"], 
                            "air_temperature" = deng2005[deng2005$cas_prediction_2007<26,"air_temperature"],
                            "cas_total" = deng2005[deng2005$cas_prediction_2007<26,"cas_total"],
                            "cas_prediction_2007" = deng2005[deng2005$cas_prediction_2007<26,"cas_prediction_2007"])

#===================COMPARAISON DES NUAGES DE POINTS DE 2005 ET DES PREDICTIONS===================
#Comparaison nuage de points (2005-2007)
par(mfrow=c(1,2))
plot(deng2005$cas_total ~ deng2005$air_temperature, xlab="Temperature de l'air", ylab="Nombres de cas de Deng", main="Cas de Deng 2005")
abline(model, col="red")
plot(deng2005$cas_prediction_2007 ~ deng2005$air_temperature, xlab="Temperature de l'air (C)", ylab="Nombres de cas de Deng", main="Prdictions de Deng 2007")
abline(model, col="red")

#Comparaison nuage de points pour les tempratures < 26C (2005-2007)
par(mfrow=c(1,2))
plot(deng2005[deng2005$air_temperature<26,"cas_total"] ~ deng2005[deng2005$air_temperature<26,"air_temperature"], xlab="Temperature de l'air (C)", ylab="Cas de Deng", main="Deng de 2005 (<26C)", ylim=c(0,140))
abline(model, col="red")
plot(dengPredInf26$cas_prediction_2007 ~ dengPredInf26$air_temperature, xlab="Temperature de l'air (C)", ylab="Cas de Deng", main="Prdictions Deng de 2007 (<26C)", ylim=c(0,140))
abline(model, col="red")

#Comparaison nuage de points pour les tempratures > 26C (2005-2007)
par(mfrow=c(1,2))
plot(deng2005[deng2005$air_temperature>26,"cas_total"] ~ deng2005[deng2005$air_temperature>26,"air_temperature"], xlab="Temperature de l'air (C)", ylab="Cas de Deng", main="Deng de 2005 (>26C)", ylim=c(0,90))
abline(model, col="red")
plot(dengPredSup26$cas_prediction_2007 ~ dengPredSup26$air_temperature, xlab="Temperature de l'air (C)", ylab="Cas de Deng", main="Prdictions Deng de 2007 (>26C)", ylim=c(0,90))
abline(model, col="red")