#On importe les modules de l'application
import urllib
import bs4 
import pandas
import folium
import seaborn
from dms2dec.dms_convert import dms2dec

#On initialise le site a scraper
url = "https://fr.wikipedia.org/wiki/Liste_d%27%C3%A9ruptions_volcaniques_au_XXIe_si%C3%A8cle"
page = urllib.request.urlopen(url).read()
html = bs4.BeautifulSoup(page, "lxml")

# Recherches des infos du tableau principal
tableauVolcan = html.find('table', {'class' : 'wikitable sortable'})
tableBody = tableauVolcan.find('tbody')
lesVolcans = tableBody.find_all('tr')



#On initialise le dataframe qui va contenir toutes les donnees
df = pandas.DataFrame(columns=['Volcan','Pays','Altitude','Derniere_eruption','Coordonnees'])

#On met l'indice qui va aider a parcourir les volcans du dataframe 
i = 0

#Pour 1 volcan dans les donnees scraper du site
for unVolcan in lesVolcans:
    
    #On recherche toutes les infos dans les cases 'td' du table
    infosVolcan = unVolcan.find_all('td')
      
    #On garde le text brut
    listeColonne = [uneInfo.text.strip() for uneInfo in infosVolcan]
        
    #si ce n'est pas la ligne d'entete, on affiche le volcan
    if len(listeColonne) > 0:
        i = i + 1
        #ajout d'une ligne dans le dataframe
        df.loc[i] = [listeColonne[0], listeColonne[1], listeColonne[2], listeColonne[3], listeColonne[4]]
    
#On remet l'indice a 0 pour eviter les erreurs
i = 0

#On creer 2 nouvelles colonnes dans le dataframe
df['Latitude'] = ""
df['Longitude'] = ""

#Pour une coordonnee dans le dataframe
for uneCoordonnee in df['Coordonnees']:
    
    #On garde la coordonnee dans la variable DMS
    DMS = uneCoordonnee
    
    #On separe la coordonnee DMS avec le caractere ,
    lstCoordonnees = DMS.split(',')
    
    #Avec la separation, une liste sera cree et la valeur de l'index 0 sera la latitude et la valeur de l'index 1 sera la longitude
    #On utilise la fonction de la libraire dms2dec pour convertir les elements dans la liste lstCoordonnees
    latitude = dms2dec(lstCoordonnees[0])
    longitude = dms2dec(lstCoordonnees[1])
    
    #On creer 2 colonnes latitude et longitude dans le dataframe
    df['Latitude'][i] = latitude
    df['Longitude'][i] = longitude
    
    #On incremente l'indice
    i = i + 1
    
#On enleve les valeurs manquantes dans la latitude et la longitude
df = df.dropna(subset = ['Latitude', 'Longitude'])
    
#On initialise une palette pour les icones
palette = seaborn.color_palette("coolwarm", 8)

#Diagramme qui compte le nombres de volcans par pays
seaborn.catplot(x = df['Pays'], data = df, kind = "count").set(title="Distribution des taux de réussite par ville de l'ex région Poitou-charentes", xlabel="Ville", ylabel="Taux de réussite")

# #On initialise les inficateurs pour afficher les icones sur la carte
# centre = [145.0000, 25.0000]
# # so = df[['Latitude', 'Longitude']].min().values.tolist()
# # ne = df[['Latitude', 'Longitude']].max().values.tolist()
    
# #On declare la carte avec les volcans present dans le dataframe
# m = folium.Map(location = centre, tiles='Stamen Toner')
    
# #On remet a 0 l'indice
# i = 0
    
# #Pour chaque volcan dans le dataframe, on affiche un marqueur sur la carte
# #On ecrit egalement des informations (Nom volcan, altitude...) des volcans
# for i in range(0,len(df)):
#     folium.Marker([df.iloc[i]['Latitude'], df.iloc[i]['Longitude']],
#                   popup=folium.Popup("<b>Nom </b>: "+str(df.iloc[i]['Volcan'])+"<br/><b>Altitude </b>: "+str(df.iloc[i]['Altitude']),max_width = 400),
#                   icon=folium.Icon(color="black", icon="home")).add_to(m)
    
# #On affecte les indicateurs a la carte
# #m.fit_bounds([so, ne])
    
# #On sauvegarde la carte dans le repertoire racine de l'application sous le fichier carteVolcans.html
# m.save('carteVolcans.html') 